/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin;

import java.io.File;

import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugin.testing.MojoRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;


/**
 * <p>
 * Performs some tests on the {@link DebianPackageMojo} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.05.2016 by Gerrit Hohl
 */
public class DebianPackageMojoTest extends AbstractMojoTestCase {
	
	
	/** The Mojo rule. */
	@Rule
	public MojoRule mojoRule = new MojoRule(this);
	
	
	// ROADMAP Create own abstract class for MOJO tests based on AbstractMojoTestCase class.
	
	
	/**
	 * <p>
	 * Performs some tests on the {@link DebianPackageMojo} class.
	 * </p>
	 */
	@Test
	public void test() {
		File basedir;


		basedir = getTestFile("src/test/resources/net/sourceforge/javadpkg/plugin");
		Assert.assertNotNull(basedir);
		Assert.assertTrue(basedir.exists());
		
		try {
			this.mojoRule.executeMojo(basedir, "dpkg");
		} catch (Exception e) {
			e.printStackTrace();
			Assert.fail("Error while executing MOJO: " + e.getMessage());
			return;
		}
	}
	
	
}
