/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.reflect;

/**
 * <p>
 * The property reflection offers method for accessing property values by using
 * reflection.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public interface PropertyReflection {
	
	
	/**
	 * <p>
	 * Returns the value for the specified path.
	 * </p>
	 * <p>
	 * The path contains the name of the property which value should be
	 * returned. It also works for in-deep properties.
	 * <ul>
	 * <li>&quot;car&quot; - returns the value of the &quot;car&quot; property
	 * of the object.</li>
	 * <li>&quot;car.engine.status&quot; - gets the &quot;car&quot; property of
	 * the object, then gets the &quot;engine&quot; property of the
	 * &quot;car&quot;, finally gets the &quot;status&quot; property of the
	 * &quot;engine&quot; property and returns it.</li>
	 * </ul>
	 * </p>
	 *
	 * @param obj
	 *            The object.
	 * @param path
	 *            The path.
	 * @return The value of the property or <code>null</code>, if the property
	 *         is <code>null</code>.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws PropertyReflectionException
	 *             If an error occurs.
	 */
	Object getValue(Object obj, String path) throws PropertyReflectionException;
	
	
}
