/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.io.impl;

import java.io.File;
import java.io.FileFilter;

/**
 * <p>
 * A file filter which supports the wildcards &quot;?&quot; (for single
 * characters) and &quot;*&quot; (for no or more characters).
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 10.05.2016 by Gerrit Hohl
 */
public class WildcardFileFilter implements FileFilter {
	
	
	/** The filter. */
	private org.apache.commons.io.filefilter.WildcardFileFilter	filter;
	/**
	 * <p>
	 * The flag if directories should be accepted by the filter - if they match
	 * the pattern.
	 * </p>
	 */
	private boolean												acceptDirectories;
	
	
	/**
	 * <p>
	 * Creates a file filter.
	 * </p>
	 *
	 * @param pattern
	 *            The pattern.
	 * @param acceptDirectories
	 *            The flag if directories should be accepted by the filter - if
	 *            they match the pattern.
	 * @throws IllegalArgumentException
	 *             If the pattern is <code>null</code>.
	 */
	public WildcardFileFilter(String pattern, boolean acceptDirectories) {
		super();
		
		if (pattern == null)
			throw new IllegalArgumentException("Argument pattern is null.");
		
		this.filter = new org.apache.commons.io.filefilter.WildcardFileFilter(pattern);
		this.acceptDirectories = acceptDirectories;
	}


	@Override
	public boolean accept(File pathname) {
		boolean accept;


		if (pathname == null)
			throw new IllegalArgumentException("Argument pathname is null.");
		
		// --- Do we accept directories? ---
		if (pathname.isDirectory() && !this.acceptDirectories)
			return false;
		
		// --- Does the name match the pattern? ---
		accept = this.filter.accept(pathname);

		return accept;
	}
	
	
}
