/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.io;


/**
 * <p>
 * A path.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 10.05.2016 by Gerrit Hohl
 */
public interface Path {
	
	
	/**
	 * <p>
	 * Returns the path of the parent.
	 * </p>
	 * <p>
	 * If this path is <code>/usr/local</code> this method will return the path
	 * <code>/usr</code>.
	 * </p>
	 *
	 * @return The path or <code>null</code>, if the path doesn't have a parent.
	 */
	Path getParentPath();
	
	
	/**
	 * <p>
	 * Returns the path of the child.
	 * </p>
	 * <p>
	 * If this path is <code>/usr/local</code> this method will return the path
	 * <code>/local<code>.
	 * </p>
	 *
	 * @return The path or <code>null</code>, if the path doesn't have a child.
	 */
	Path getChildPath();


	/**
	 * <p>
	 * Creates the specified child for this path and returns it as a new path.
	 * </p>
	 * <p>
	 * If this path is <code>/usr</code> and the name of the child is
	 * <code>local</code> the returned new path will be <code>/usr/local</code>.
	 * </p>
	 *
	 * @param name
	 *            The name of the child.
	 * @return The new path.
	 * @throws IllegalArgumentException
	 *             If the name is <code>null</code>.
	 */
	Path createChild(String name);
	
	
	/**
	 * <p>
	 * Returns the first element of the path.
	 * </p>
	 *
	 * @return The first element or <code>null</code>, if this path represents
	 *         the root path.
	 */
	String getFirstElement();
	
	
	/**
	 * <p>
	 * Returns the last element of the path.
	 * </p>
	 *
	 * @return The last element or <code>null</code>, if this path represents
	 *         the root path.
	 */
	String getLastElement();


	/**
	 * <p>
	 * Returns the path as string.
	 * </p>
	 *
	 * @return The path.
	 */
	String getAbsolutePath();
	
	
}
