/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;

import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.plugin.TargetFileBuilder;


/**
 * <p>
 * A {@link TargetFileBuilder} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.05.2016 by Gerrit Hohl
 */
public class TargetFileBuilderImpl implements TargetFileBuilder {
	
	
	/**
	 * <p>
	 * Creates a builder.
	 * </p>
	 */
	public TargetFileBuilderImpl() {
		super();
	}


	@Override
	public File createTargetFile(File targetDirectory, BinaryControl control) {
		File targetFile;
		
		
		if (targetDirectory == null)
			throw new IllegalArgumentException("Argument targetDirectory is null.");
		if (control == null)
			throw new IllegalArgumentException("Argument control is null.");
		
		targetFile = this.createTargetFile(targetDirectory, control.getPackage(), control.getVersion(),
				control.getArchitecture());
		return targetFile;
	}


	@Override
	public File createTargetFile(File targetDirectory, PackageName name, PackageVersion version, Architecture architecture) {
		File targetFile;
		StringBuilder sb;
		
		
		if (targetDirectory == null)
			throw new IllegalArgumentException("Argument targetDirectory is null.");
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");
		if (version == null)
			throw new IllegalArgumentException("Argument version is null.");
		if (architecture == null)
			throw new IllegalArgumentException("Argument architecture is null.");
		
		sb = new StringBuilder();

		// --- Package name ---
		sb.append(name.getName());
		sb.append('_');

		// --- Version ---
		sb.append(version.getUpstreamVersion());
		if (version.getDebianRevision() != null) {
			sb.append('-');
			sb.append(version.getDebianRevision());
		}
		sb.append('_');

		// --- Architecture ---
		sb.append(architecture.getText());

		// --- Suffix ---
		sb.append(".deb");
		
		targetFile = new File(targetDirectory, sb.toString());
		return targetFile;
	}


}
