/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import net.sourceforge.javadpkg.plugin.io.FileSystemNode;

/**
 * <p>
 * The additional information of the {@link FileSystemNode} used by the
 * {@link DataConfigurationParserImpl} and the {@link DataFileSystemNodeVisitor}
 * class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 19.05.2016 by Gerrit Hohl
 */
public class FileSystemNodeInfo {
	
	
	/** The information about the source. */
	private FileInfo	source;
	/** The flag if the file should be processed. */
	private boolean		process;
	/** The encoding for the processing. */
	private String		encoding;


	/**
	 * <p>
	 * Creates optional parameters.
	 * </p>
	 *
	 * @param source
	 *            The information about the source file.
	 * @param process
	 *            The flag if the file should be processed.
	 * @param encoding
	 *            The encoding for the processing (optional).
	 * @throws IllegalArgumentException
	 *             If any of the non-optional parameters are <code>null</code>.
	 */
	public FileSystemNodeInfo(FileInfo source, boolean process, String encoding) {
		super();

		if (source == null)
			throw new IllegalArgumentException("Argument source is null.");
		
		this.source = source;
		this.process = process;
		this.encoding = encoding;
	}


	/**
	 * <p>
	 * Returns the information about the source file.
	 * </p>
	 *
	 * @return The file information.
	 */
	public FileInfo getSource() {
		return this.source;
	}


	/**
	 * <p>
	 * Returns the flag if the file should be processed.
	 * </p>
	 *
	 * @return The flag: <code>true</code>, if the file should be processed,
	 *         <code>false</code> otherwise.
	 * @see #getEncoding()
	 */
	public boolean isProcess() {
		return this.process;
	}
	
	
	/**
	 * <p>
	 * Returns the encoding for the processing.
	 * </p>
	 * <p>
	 * This flag has only an effect if this node should be processed.
	 * </p>
	 *
	 * @return The encoding or <code>null</code>, if the default encoding should
	 *         be used.
	 * @see #isProcess()
	 */
	public String getEncoding() {
		return this.encoding;
	}


}
