/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;

/**
 * <p>
 * A {@link FileInfo} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 20.05.2016 by Gerrit Hohl
 */
public class FileInfoImpl implements FileInfo {
	
	
	/** The file. */
	private File file;
	
	
	/**
	 * <p>
	 * Creates a file information for the specified file.
	 * </p>
	 *
	 * @param file
	 *            The file.
	 * @throws IllegalArgumentException
	 *             If the file is <code>null</code>.
	 */
	public FileInfoImpl(File file) {
		super();
		
		if (file == null)
			throw new IllegalArgumentException("Argument file is null.");
		
		this.file = file;
	}
	
	
	@Override
	public File getFile() {
		return this.file;
	}
	
	
	@Override
	public String getAbsolutePath() {
		return this.file.getAbsolutePath();
	}
	
	
	@Override
	public boolean exists() {
		return this.file.exists();
	}
	
	
	@Override
	public boolean isFile() {
		return this.file.isFile();
	}
	
	
	@Override
	public boolean isDirectory() {
		return this.file.isDirectory();
	}
	
	
	@Override
	public long getLength() {
		return this.file.length();
	}
	
	
}
