/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;

/**
 * <p>
 * The information about a file.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 20.05.2016 by Gerrit Hohl
 */
public interface FileInfo {
	
	
	/**
	 * <p>
	 * Returns the file.
	 * </p>
	 *
	 * @return The file.
	 */
	File getFile();
	
	
	/**
	 * <p>
	 * Returns the absolute path.
	 * </p>
	 *
	 * @return The absolute path.
	 */
	String getAbsolutePath();
	
	
	/**
	 * <p>
	 * Returns the flag if the file exists.
	 * </p>
	 * 
	 * @return The flag: <code>true</code>, if the file exists,
	 *         <code>false</code> otherwise.
	 */
	boolean exists();
	
	
	/**
	 * <p>
	 * Returns the flag if the file is a regular file.
	 * </p>
	 * 
	 * @return The flag: <code>true</code>, if the file is a regular file,
	 *         <code>false</code> otherwise.
	 */
	boolean isFile();
	
	
	/**
	 * <p>
	 * Returns the flag if the file is a directory.
	 * </p>
	 * 
	 * @return The flag: <code>true</code>, if the file is a directory,
	 *         <code>false</code> otherwise.
	 */
	boolean isDirectory();


	/**
	 * <p>
	 * Returns the length of the file in bytes.
	 * </p>
	 *
	 * @return The length.
	 */
	long getLength();
	
	
}
