/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import java.io.File;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The configuration of an installation scripts.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public class ScriptConfiguration {
	
	
	/** The type. */
	@Parameter(name = "type", required = true)
	private ScriptType	type;
	/** The file. */
	@Parameter(name = "file")
	private File		file;
	/** The content. */
	@Parameter(name = "content")
	private String		content;
	
	
	/**
	 * <p>
	 * Creates a configuration.
	 * </p>
	 */
	public ScriptConfiguration() {
		super();

		this.type = null;
		this.file = null;
		this.content = null;
	}


	/**
	 * <p>
	 * Returns the type.
	 * </p>
	 * 
	 * @return The type.
	 */
	public ScriptType getType() {
		return this.type;
	}


	/**
	 * <p>
	 * Sets the type.
	 * </p>
	 * 
	 * @param type
	 *            The type.
	 */
	public void setType(ScriptType type) {
		this.type = type;
	}


	/**
	 * <p>
	 * Returns the file.
	 * </p>
	 * 
	 * @return The file.
	 */
	public File getFile() {
		return this.file;
	}


	/**
	 * <p>
	 * Sets the file.
	 * </p>
	 * 
	 * @param file
	 *            The file.
	 */
	public void setFile(File file) {
		this.file = file;
	}


	/**
	 * <p>
	 * Returns the content.
	 * </p>
	 * 
	 * @return The content.
	 */
	public String getContent() {
		return this.content;
	}


	/**
	 * <p>
	 * Sets the content.
	 * </p>
	 * 
	 * @param content
	 *            The content.
	 */
	public void setContent(String content) {
		this.content = content;
	}


}
