/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The license configuration.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 09.05.2016 by Gerrit Hohl
 */
public class CopyrightLicenseConfiguration {
	
	
	/** The name. */
	@Parameter(name = "name", required = true)
	private String	name;
	/** The text. */
	@Parameter(name = "text")
	private String	text;
	
	
	/**
	 * <p>
	 * Creates a configuration
	 * </p>
	 */
	public CopyrightLicenseConfiguration() {
		super();
		
		this.name = null;
		this.text = null;
	}
	
	
	/**
	 * <p>
	 * Returns the name.
	 * </p>
	 *
	 * @return The name or <code>null</code>, if no name is set.
	 */
	public String getName() {
		return this.name;
	}
	
	
	/**
	 * <p>
	 * Sets the name.
	 * </p>
	 *
	 * @param name
	 *            The name.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	
	/**
	 * <p>
	 * Returns the text.
	 * </p>
	 *
	 * @return The text.
	 */
	public String getText() {
		return this.text;
	}
	
	
	/**
	 * <p>
	 * Sets the text.
	 * </p>
	 *
	 * @param text
	 *            The text.
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	
}
