/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The files copyright configurations.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 09.05.2016 by Gerrit Hohl
 */
public class CopyrightFilesConfiguration {
	
	
	/** The patterns for which files the copyright applies. */
	@Parameter(name = "files", required = true)
	private List<String>					files;
	/** The copyright. */
	@Parameter(name = "copyright")
	private String							copyright;
	/** The license. */
	@Parameter(name = "license")
	private CopyrightLicenseConfiguration	license;
	/** The comment. */
	@Parameter(name = "comment")
	private String							comment;
	
	
	/**
	 * <p>
	 * Creates the configuration.
	 * </p>
	 */
	public CopyrightFilesConfiguration() {
		super();
		
		this.files = new ArrayList<>();
		this.copyright = null;
		this.license = null;
		this.comment = null;
	}
	
	
	/**
	 * <p>
	 * Returns the patterns for which files the copyright applies.
	 * </p>
	 *
	 * @return The patterns.
	 */
	public List<String> getFiles() {
		return (new ArrayList<>(this.files));
	}
	
	
	/**
	 * <p>
	 * Sets the patterns for which files the copyright applies.
	 * </p>
	 *
	 * @param files
	 *            The patterns.
	 */
	public void setFiles(List<String> files) {
		if (files == null) {
			this.files = new ArrayList<>();
		} else {
			this.files = new ArrayList<>(files);
		}
	}
	
	
	/**
	 * <p>
	 * Returns the copyright.
	 * </p>
	 * 
	 * @return The copyright or <code>null</code>, if no copyright is set.
	 */
	public String getCopyright() {
		return this.copyright;
	}
	
	
	/**
	 * <p>
	 * Sets the copyright.
	 * </p>
	 * 
	 * @param copyright
	 *            The copyright.
	 */
	public void setCopyright(String copyright) {
		this.copyright = copyright;
	}
	
	
	/**
	 * <p>
	 * Returns the license.
	 * </p>
	 * 
	 * @return The license or <code>null</code>, if no license is set.
	 */
	public CopyrightLicenseConfiguration getLicense() {
		return this.license;
	}
	
	
	/**
	 * <p>
	 * Sets the license.
	 * </p>
	 * 
	 * @param license
	 *            The license.
	 */
	public void setLicense(CopyrightLicenseConfiguration license) {
		this.license = license;
	}
	
	
	/**
	 * <p>
	 * Returns the comment.
	 * </p>
	 * 
	 * @return The comment or <code>null</code>, if no comment is set.
	 */
	public String getComment() {
		return this.comment;
	}
	
	
	/**
	 * <p>
	 * Sets the comment.
	 * </p>
	 * 
	 * @param comment
	 *            The comment.
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}
	
	
}
