/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The control configuration.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.05.2016 by Gerrit Hohl
 */
public class ControlConfiguration {
	
	
	/** The name of the package. */
	@Parameter(name = "name", required = true)
	private String						name;
	/** The version. */
	@Parameter(name = "version", required = true)
	private String						version;
	/** The architecture. */
	@Parameter(name = "architecture", required = true)
	private String						architecture;
	/** The section. */
	@Parameter(name = "section")
	private String						section;
	/** The priority. */
	@Parameter(name = "priority")
	private String						priority;
	/** The installed size or the overhead. */
	private String						installedSize;
	/** The dependencies. */
	@Parameter(name = "depends")
	private DependenciesConfiguration	depends;
	/** The &quot;Recommends&quot; dependencies. */
	@Parameter(name = "recommends")
	private DependenciesConfiguration	recommends;
	/** The &quot;Suggests&quot; dependencies. */
	@Parameter(name = "suggests")
	private DependenciesConfiguration	suggests;
	/** The &quot;Enhances&quot; dependencies. */
	@Parameter(name = "enhances")
	private DependenciesConfiguration	enhances;
	/** The &quot;Pre-Depends&quot; dependencies. */
	@Parameter(name = "preDepends")
	private DependenciesConfiguration	preDepends;
	/** The &quot;Breaks&quot; dependencies. */
	@Parameter(name = "breaks")
	private DependenciesConfiguration	breaks;
	/** The &quot;Conflicts&quot; dependencies. */
	@Parameter(name = "conflicts")
	private DependenciesConfiguration	conflicts;
	/** The &quot;Provides&quot; dependencies. */
	@Parameter(name = "provides")
	private DependenciesConfiguration	provides;
	/** The &quot;Replaces&quot; dependencies. */
	@Parameter(name = "replaces")
	private DependenciesConfiguration	replaces;
	/** The &quot;Built-Using&quot; dependencies. */
	@Parameter(name = "builtUsing")
	private DependenciesConfiguration	builtUsing;
	/** The maintainer. */
	@Parameter(name = "maintainer", required = true)
	private String						maintainer;
	/** The home-page. */
	@Parameter(name = "homepage")
	private String						homepage;
	/** The description. */
	@Parameter(name = "description", required = true)
	private String						description;
	
	
	/**
	 * <p>
	 * Creates a configuration.
	 * </p>
	 */
	public ControlConfiguration() {
		super();

		this.name = null;
		this.version = null;
		this.architecture = null;
		this.section = null;
		this.priority = null;
		this.installedSize = null;
		this.depends = null;
		this.recommends = null;
		this.suggests = null;
		this.enhances = null;
		this.preDepends = null;
		this.breaks = null;
		this.conflicts = null;
		this.provides = null;
		this.replaces = null;
		this.builtUsing = null;
		this.maintainer = null;
		this.homepage = null;
		this.description = null;
	}


	/**
	 * <p>
	 * Returns the name of the package.
	 * </p>
	 *
	 * @return The name.
	 */
	public String getName() {
		return this.name;
	}


	/**
	 * <p>
	 * Sets the name of the package.
	 * </p>
	 *
	 * @param name
	 *            The name.
	 */
	public void setName(String name) {
		this.name = name;
	}


	/**
	 * <p>
	 * Returns the version.
	 * </p>
	 *
	 * @return The version.
	 */
	public String getVersion() {
		return this.version;
	}


	/**
	 * <p>
	 * Sets the version.
	 * </p>
	 *
	 * @param version
	 *            The version.
	 */
	public void setVersion(String version) {
		this.version = version;
	}


	/**
	 * <p>
	 * Returns the architecture.
	 * </p>
	 *
	 * @return The architecture.
	 */
	public String getArchitecture() {
		return this.architecture;
	}


	/**
	 * <p>
	 * Sets the architecture.
	 * </p>
	 *
	 * @param architecture
	 *            The architecture.
	 */
	public void setArchitecture(String architecture) {
		this.architecture = architecture;
	}


	/**
	 * <p>
	 * Returns the section.
	 * </p>
	 *
	 * @return The section.
	 */
	public String getSection() {
		return this.section;
	}


	/**
	 * <p>
	 * Sets the section.
	 * </p>
	 *
	 * @param section
	 *            The section.
	 */
	public void setSection(String section) {
		this.section = section;
	}


	/**
	 * <p>
	 * Returns the priority.
	 * </p>
	 *
	 * @return The priority.
	 */
	public String getPriority() {
		return this.priority;
	}


	/**
	 * <p>
	 * Sets the priority.
	 * </p>
	 *
	 * @param priority
	 *            The priority.
	 */
	public void setPriority(String priority) {
		this.priority = priority;
	}
	
	
	/**
	 * <p>
	 * Returns the installed size or the overhead.
	 * </p>
	 * <p>
	 * An overhead can be specified by placing a plus sign before the number. In
	 * this case the real installed size will be calculated by summing up the
	 * sizes of the added files. Then the overhead will be added.
	 * </p>
	 *
	 * @return The installed size or the overhead in kilobytes.
	 */
	public String getInstalledSize() {
		return this.installedSize;
	}
	
	
	/**
	 * <p>
	 * Sets the installed size or the overhead.
	 * </p>
	 * <p>
	 * An overhead can be specified by placing a plus sign before the number. In
	 * this case the real installed size will be calculated by summing up the
	 * sizes of the added files. Then the overhead will be added.
	 * </p>
	 *
	 * @param installedSize
	 *            The installed size or the overhead in kilobytes
	 */
	public void setInstalledSize(String installedSize) {
		this.installedSize = installedSize;
	}
	
	
	/**
	 * <p>
	 * Returns the dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getDepends() {
		return this.depends;
	}


	/**
	 * <p>
	 * Sets the dependencies.
	 * </p>
	 *
	 * @param depends
	 *            The dependencies.
	 */
	public void setDepends(DependenciesConfiguration depends) {
		this.depends = depends;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Recommends&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getRecommends() {
		return this.recommends;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Recommends&quot; dependencies.
	 * </p>
	 *
	 * @param recommends
	 *            The dependencies.
	 */
	public void setRecommends(DependenciesConfiguration recommends) {
		this.recommends = recommends;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Suggest&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getSuggests() {
		return this.suggests;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Suggest&quot; dependencies.
	 * </p>
	 *
	 * @param suggests
	 *            The dependencies.
	 */
	public void setSuggests(DependenciesConfiguration suggests) {
		this.suggests = suggests;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Enhances&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getEnhances() {
		return this.enhances;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Enhances&quot; dependencies.
	 * </p>
	 *
	 * @param enhances
	 *            The dependencies.
	 */
	public void setEnhances(DependenciesConfiguration enhances) {
		this.enhances = enhances;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Pre-Depends&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getPreDepends() {
		return this.preDepends;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Pre-Depends&quot; dependencies.
	 * </p>
	 *
	 * @param preDepends
	 *            The dependencies.
	 */
	public void setPreDepends(DependenciesConfiguration preDepends) {
		this.preDepends = preDepends;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Breaks&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getBreaks() {
		return this.breaks;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Breaks&quot; dependencies.
	 * </p>
	 *
	 * @param breaks
	 *            The dependencies.
	 */
	public void setBreaks(DependenciesConfiguration breaks) {
		this.breaks = breaks;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Conflicts&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getConflicts() {
		return this.conflicts;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Conflicts&quot; dependencies.
	 * </p>
	 *
	 * @param conflicts
	 *            The dependencies.
	 */
	public void setConflicts(DependenciesConfiguration conflicts) {
		this.conflicts = conflicts;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Provides&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getProvides() {
		return this.provides;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Provides&quot; dependencies.
	 * </p>
	 *
	 * @param provides
	 *            The dependencies.
	 */
	public void setProvides(DependenciesConfiguration provides) {
		this.provides = provides;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Replaces&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getReplaces() {
		return this.replaces;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Replaces&quot; dependencies.
	 * </p>
	 *
	 * @param replaces
	 *            The dependencies.
	 */
	public void setReplaces(DependenciesConfiguration replaces) {
		this.replaces = replaces;
	}
	
	
	/**
	 * <p>
	 * Returns the &quot;Built-Using&quot; dependencies.
	 * </p>
	 *
	 * @return The dependencies.
	 */
	public DependenciesConfiguration getBuiltUsing() {
		return this.builtUsing;
	}
	
	
	/**
	 * <p>
	 * Sets the &quot;Built-Using&quot; dependencies.
	 * </p>
	 *
	 * @param builtUsing
	 *            The dependencies.
	 */
	public void setBuiltUsing(DependenciesConfiguration builtUsing) {
		this.builtUsing = builtUsing;
	}
	
	
	/**
	 * <p>
	 * Returns the maintainer.
	 * </p>
	 *
	 * @return The maintainer.
	 */
	public String getMaintainer() {
		return this.maintainer;
	}


	/**
	 * <p>
	 * Sets the maintainer.
	 * </p>
	 *
	 * @param maintainer
	 *            The maintainer.
	 */
	public void setMaintainer(String maintainer) {
		this.maintainer = maintainer;
	}


	/**
	 * <p>
	 * Returns the home-page.
	 * </p>
	 *
	 * @return The home-page.
	 */
	public String getHomepage() {
		return this.homepage;
	}


	/**
	 * <p>
	 * Sets the home-page.
	 * </p>
	 *
	 * @param homepage
	 *            The home-page.
	 */
	public void setHomepage(String homepage) {
		this.homepage = homepage;
	}


	/**
	 * <p>
	 * Returns the description.
	 * </p>
	 *
	 * @return The description.
	 */
	public String getDescription() {
		return this.description;
	}


	/**
	 * <p>
	 * Sets the description.
	 * </p>
	 *
	 * @param description
	 *            The description.
	 */
	public void setDescription(String description) {
		this.description = description;
	}


}
