/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The configuration of an entry for a version.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 09.05.2016 by Gerrit Hohl
 */
public class ChangeLogVersionEntryConfiguration {
	
	
	/** The name of the package. */
	@Parameter(name = "name", required = true)
	private String			name;
	/** The version. */
	@Parameter(name = "version", required = true)
	private String			version;
	/** The distributions. */
	@Parameter(name = "distributions", required = true)
	private List<String>	distributions;
	/** The urgency of the version. */
	@Parameter(name = "urgency", required = true)
	private String			urgency;
	/** The details. */
	@Parameter(name = "details", required = true)
	private List<String>	details;
	/** The maintainer. */
	@Parameter(name = "maintainer", required = true)
	private String			maintainer;
	/** The date. */
	@Parameter(name = "date", required = true)
	private String			date;
	
	
	/**
	 * <p>
	 * Creates a configuration.
	 * </p>
	 */
	public ChangeLogVersionEntryConfiguration() {
		super();
		
		this.name = null;
		this.version = null;
		this.distributions = new ArrayList<>();
		this.urgency = null;
		this.details = new ArrayList<>();
		this.maintainer = null;
		this.date = null;
	}
	
	
	/**
	 * <p>
	 * Returns the name of the package.
	 * </p>
	 *
	 * @return The name or <code>null</code>, if no name is set.
	 */
	public String getName() {
		return this.name;
	}
	
	
	/**
	 * <p>
	 * Sets the name of the package.
	 * </p>
	 *
	 * @param name
	 *            The name.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	
	/**
	 * <p>
	 * Returns the version.
	 * </p>
	 *
	 * @return The version or <code>null</code>, if no version is set.
	 */
	public String getVersion() {
		return this.version;
	}
	
	
	/**
	 * <p>
	 * Sets the version.
	 * </p>
	 *
	 * @param version
	 *            The version.
	 */
	public void setVersion(String version) {
		this.version = version;
	}
	
	
	/**
	 * <p>
	 * Returns the distributions.
	 * </p>
	 *
	 * @return The distributions.
	 */
	public List<String> getDistributions() {
		return (new ArrayList<>(this.distributions));
	}
	
	
	/**
	 * <p>
	 * Sets the distributions.
	 * </p>
	 *
	 * @param distributions
	 *            The distributions.
	 */
	public void setDistributions(List<String> distributions) {
		if (distributions == null) {
			this.distributions = new ArrayList<>();
		} else {
			this.distributions = new ArrayList<>(distributions);
		}
	}
	
	
	/**
	 * <p>
	 * Returns the urgency of the version.
	 * </p>
	 *
	 * @return The urgency or <code>null</code>, if no urgency is set.
	 */
	public String getUrgency() {
		return this.urgency;
	}
	
	
	/**
	 * <p>
	 * Sets the urgency of the version.
	 * </p>
	 *
	 * @param urgency
	 *            The urgency.
	 */
	public void setUrgency(String urgency) {
		this.urgency = urgency;
	}
	
	
	/**
	 * <p>
	 * Returns the details.
	 * </p>
	 *
	 * @return The details.
	 */
	public List<String> getDetails() {
		return (new ArrayList<>(this.details));
	}
	
	
	/**
	 * <p>
	 * Sets the details.
	 * </p>
	 *
	 * @param details
	 *            The details.
	 */
	public void setDetails(List<String> details) {
		if (details == null) {
			this.details = new ArrayList<>();
		} else {
			this.details = new ArrayList<>(details);
		}
	}
	
	
	/**
	 * <p>
	 * Returns the maintainer.
	 * </p>
	 * 
	 * @return The maintainer or <code>null</code>, if no maintainer is set.
	 */
	public String getMaintainer() {
		return this.maintainer;
	}
	
	
	/**
	 * <p>
	 * Sets the maintainer.
	 * </p>
	 * 
	 * @param maintainer
	 *            The maintainer.
	 */
	public void setMaintainer(String maintainer) {
		this.maintainer = maintainer;
	}
	
	
	/**
	 * <p>
	 * Returns the date.
	 * </p>
	 * 
	 * @return The date or <code>null</code>, if no date is set.
	 */
	public String getDate() {
		return this.date;
	}
	
	
	/**
	 * <p>
	 * Sets the date.
	 * </p>
	 * 
	 * @param date
	 *            The date.
	 */
	public void setDate(String date) {
		this.date = date;
	}
	
	
}
