/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.cfg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * The change log configuration.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 09.05.2016 by Gerrit Hohl
 */
public class ChangeLogConfiguration {
	
	
	/** The file. */
	@Parameter(name = "file")
	private File										file;
	/** The entries. */
	@Parameter(name = "entries")
	private List<ChangeLogVersionEntryConfiguration>	entries;
	
	
	/**
	 * <p>
	 * Creates the configuration.
	 * </p>
	 */
	public ChangeLogConfiguration() {
		super();

		this.file = null;
		this.entries = new ArrayList<>();
	}


	/**
	 * <p>
	 * Returns the file.
	 * </p>
	 *
	 * @return The file or <code>null</code>, if no file is set.
	 */
	public File getFile() {
		return this.file;
	}
	
	
	/**
	 * <p>
	 * Sets the file.
	 * </p>
	 *
	 * @param file
	 *            The file.
	 */
	public void setFile(File file) {
		this.file = file;
	}
	
	
	/**
	 * <p>
	 * Returns the entries.
	 * </p>
	 * 
	 * @return The entries.
	 */
	public List<ChangeLogVersionEntryConfiguration> getEntries() {
		return (new ArrayList<>(this.entries));
	}
	
	
	/**
	 * <p>
	 * Sets the entries.
	 * </p>
	 * 
	 * @param entries
	 *            The entries.
	 */
	public void setEntries(List<ChangeLogVersionEntryConfiguration> entries) {
		if (entries == null) {
			this.entries = new ArrayList<>();
		} else {
			this.entries = new ArrayList<>(entries);
		}
	}
	
	
}
