/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin;

import java.io.File;

import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;

/**
 * <p>
 * Builds the name and path of the target file.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.05.2016 by Gerrit Hohl
 */
public interface TargetFileBuilder {
	
	
	/**
	 * <p>
	 * Creates the target file.
	 * </p>
	 * <p>
	 * This method creates only the filename, but not the file itself.
	 * </p>
	 *
	 * @param targetDirectory
	 *            The target directory.
	 * @param control
	 *            The binary control.
	 * @return The target file.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	File createTargetFile(File targetDirectory, BinaryControl control);


	/**
	 * <p>
	 * Creates the target file.
	 * </p>
	 * <p>
	 * This method creates only the filename, but not the file itself.
	 * </p>
	 *
	 * @param targetDirectory
	 *            The target directory.
	 * @param name
	 *            The name.
	 * @param version
	 *            The version.
	 * @param architecture
	 *            The architecture.
	 * @return The target file.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	File createTargetFile(File targetDirectory, PackageName name, PackageVersion version, Architecture architecture);
	
	
}
