/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.plugin.cfg.ControlConfiguration;

/**
 * <p>
 * A builder which creates a {@link BinaryControlBuilder} based on the
 * configuration.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.05.2016 by Gerrit Hohl
 */
public interface BinaryControlBuilder {
	
	
	/**
	 * <p>
	 * Builds a control.
	 * </p>
	 *
	 * @param log
	 *            The logging.
	 * @param config
	 *            The configuration.
	 * @param installedSize
	 *            The calculated installed size.
	 * @param context
	 *            The context.
	 * @return The control.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws MojoExecutionException
	 *             If a build error occurs.
	 * @throws MojoFailureException
	 *             If an error occurs which fails the build.
	 */
	BinaryControl buildBinaryControl(Log log, ControlConfiguration config, Size installedSize, Context context)
			throws MojoExecutionException, MojoFailureException;
	
	
}
