/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.html.dom;

import net.sourceforge.htmlunit.html.dom.HTMLCollectionImpl;
import net.sourceforge.htmlunit.html.dom.HTMLDocumentImpl;
import net.sourceforge.htmlunit.html.dom.HTMLElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableCellElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableSectionElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    HTMLCollection _cells;

    @Override
    public int getRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public void setRowIndex(int rowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            ((HTMLTableElementImpl)parent).insertRowX(rowIndex, this);
        }
    }

    @Override
    public int getSectionRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            ((HTMLTableSectionElementImpl)parent).insertRowX(sectionRowIndex, this);
        }
    }

    int getRowIndex(Node parent) {
        NodeList rows = ((HTMLElement)parent).getElementsByTagName("TR");
        for (int i = 0; i < rows.getLength(); ++i) {
            if (rows.item(i) != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HTMLCollection getCells() {
        if (this._cells == null) {
            this._cells = new HTMLCollectionImpl(this, -3);
        }
        return this._cells;
    }

    public void setCells(HTMLCollection cells) {
        Node child;
        for (child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.removeChild(child);
        }
        int i = 0;
        child = cells.item(i);
        while (child != null) {
            this.appendChild(child);
            child = cells.item(++i);
        }
    }

    @Override
    public HTMLElement insertCell(int index) {
        HTMLTableCellElementImpl newCell = new HTMLTableCellElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TD");
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableCellElement)) continue;
            if (index == 0) {
                this.insertBefore(newCell, child);
                return newCell;
            }
            --index;
        }
        this.appendChild(newCell);
        return newCell;
    }

    @Override
    public void deleteCell(int index) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableCellElement)) continue;
            if (index == 0) {
                this.removeChild(child);
                return;
            }
            --index;
        }
    }

    @Override
    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    @Override
    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    @Override
    public String getCh() {
        String ch = this.getAttribute("char");
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        return ch;
    }

    @Override
    public void setCh(String ch) {
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        this.setAttribute("char", ch);
    }

    @Override
    public String getChOff() {
        return this.getAttribute("charoff");
    }

    @Override
    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    @Override
    public String getVAlign() {
        return this.capitalize(this.getAttribute("valign"));
    }

    @Override
    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    @Override
    public Node cloneNode(boolean deep) {
        HTMLTableRowElementImpl clonedNode = (HTMLTableRowElementImpl)super.cloneNode(deep);
        clonedNode._cells = null;
        return clonedNode;
    }

    public HTMLTableRowElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

