/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.html.dom;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import net.sourceforge.htmlunit.html.dom.HTMLAnchorElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLAppletElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLAreaElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLBRElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLBaseElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLBaseFontElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLBodyElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLButtonElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLCollectionImpl;
import net.sourceforge.htmlunit.html.dom.HTMLDListElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLDirectoryElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLDivElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLFieldSetElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLFontElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLFormElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLFrameElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLFrameSetElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLHRElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLHeadElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLHeadingElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLHtmlElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLIFrameElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLImageElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLInputElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLIsIndexElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLLIElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLLabelElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLLegendElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLLinkElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLMapElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLMenuElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLMetaElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLModElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLOListElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLObjectElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLOptGroupElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLOptionElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLParagraphElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLParamElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLPreElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLQuoteElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLScriptElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLSelectElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLStyleElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableCaptionElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableCellElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableColElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableRowElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTableSectionElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTextAreaElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLTitleElementImpl;
import net.sourceforge.htmlunit.html.dom.HTMLUListElementImpl;
import net.sourceforge.htmlunit.html.dom.NameNodeListImpl;
import net.sourceforge.htmlunit.xerces.dom.CoreDocumentImpl;
import net.sourceforge.htmlunit.xerces.dom.DocumentImpl;
import net.sourceforge.htmlunit.xerces.dom.ElementImpl;
import net.sourceforge.htmlunit.xerces.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFrameSetElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLHtmlElement;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    private HTMLCollectionImpl _anchors;
    private HTMLCollectionImpl _forms;
    private HTMLCollectionImpl _images;
    private HTMLCollectionImpl _links;
    private HTMLCollectionImpl _applets;
    private StringWriter _writer;
    private static HashMap<String, Class<? extends HTMLElementImpl>> _elementTypesHTML = new HashMap();
    private static final Class<?>[] _elemClassSigHTML = new Class[]{HTMLDocumentImpl.class, String.class};

    @Override
    public synchronized Element getDocumentElement() {
        Node html;
        for (html = this.getFirstChild(); html != null; html = html.getNextSibling()) {
            if (!(html instanceof HTMLHtmlElement)) continue;
            return (HTMLElement)html;
        }
        html = new HTMLHtmlElementImpl(this, "HTML");
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            html.appendChild(child);
            child = next;
        }
        this.appendChild(html);
        return (HTMLElement)html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTMLElement getHead() {
        Node head;
        Element html;
        Element element = html = this.getDocumentElement();
        synchronized (element) {
            for (head = html.getFirstChild(); head != null && !(head instanceof HTMLHeadElement); head = head.getNextSibling()) {
            }
            if (head != null) {
                Node node = head;
                synchronized (node) {
                    Node child = html.getFirstChild();
                    while (child != null && child != head) {
                        Node next = child.getNextSibling();
                        head.insertBefore(child, head.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)head;
            }
            head = new HTMLHeadElementImpl(this, "HEAD");
            html.insertBefore(head, html.getFirstChild());
        }
        return (HTMLElement)head;
    }

    @Override
    public synchronized String getTitle() {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            return ((HTMLTitleElement)title).getText();
        }
        return "";
    }

    @Override
    public synchronized void setTitle(String newTitle) {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            if (title.getParentNode() != head) {
                head.appendChild(title);
            }
            ((HTMLTitleElement)title).setText(newTitle);
        } else {
            HTMLTitleElementImpl title = new HTMLTitleElementImpl(this, "TITLE");
            ((HTMLTitleElement)title).setText(newTitle);
            head.appendChild(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HTMLElement getBody() {
        Node body;
        Element html = this.getDocumentElement();
        HTMLElement head = this.getHead();
        Element element = html;
        synchronized (element) {
            for (body = head.getNextSibling(); body != null && !(body instanceof HTMLBodyElement) && !(body instanceof HTMLFrameSetElement); body = body.getNextSibling()) {
            }
            if (body != null) {
                Node node = body;
                synchronized (node) {
                    Node child = head.getNextSibling();
                    while (child != null && child != body) {
                        Node next = child.getNextSibling();
                        body.insertBefore(child, body.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)body;
            }
            body = new HTMLBodyElementImpl(this, "BODY");
            html.appendChild(body);
        }
        return (HTMLElement)body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setBody(HTMLElement newBody) {
        HTMLElement hTMLElement = newBody;
        synchronized (hTMLElement) {
            Element html = this.getDocumentElement();
            HTMLElement head = this.getHead();
            Element element = html;
            synchronized (element) {
                NodeList list = this.getElementsByTagName("BODY");
                if (list.getLength() > 0) {
                    Node body;
                    Node node = body = list.item(0);
                    synchronized (node) {
                        for (Node child = head; child != null; child = child.getNextSibling()) {
                            if (!(child instanceof Element)) continue;
                            if (child != body) {
                                html.insertBefore(newBody, child);
                            } else {
                                html.replaceChild(newBody, body);
                            }
                            return;
                        }
                        html.appendChild(newBody);
                    }
                    return;
                }
                html.appendChild(newBody);
            }
        }
    }

    @Override
    public synchronized Element getElementById(String elementId) {
        Element idElement = super.getElementById(elementId);
        if (idElement != null) {
            return idElement;
        }
        return this.getElementById(elementId, this);
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        return new NameNodeListImpl((NodeImpl)this, elementName);
    }

    @Override
    public final NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getElementsByTagNameNS(namespaceURI, localName.toUpperCase(Locale.ENGLISH));
        }
        return super.getElementsByTagName(localName.toUpperCase(Locale.ENGLISH));
    }

    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return this.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return this.createElement(qualifiedName);
        }
        return super.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        Class<? extends HTMLElementImpl> elemClass = _elementTypesHTML.get(tagName = tagName.toUpperCase(Locale.ENGLISH));
        if (elemClass != null) {
            try {
                Constructor<? extends HTMLElementImpl> cnst = elemClass.getConstructor(_elemClassSigHTML);
                return cnst.newInstance(this, tagName);
            }
            catch (Exception except) {
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.\n" + tagName);
            }
        }
        return new HTMLElementImpl(this, tagName);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return super.createAttribute(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getReferrer() {
        return null;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getCookie() {
        return null;
    }

    @Override
    public void setCookie(String cookie) {
    }

    @Override
    public HTMLCollection getImages() {
        if (this._images == null) {
            this._images = new HTMLCollectionImpl(this.getBody(), 3);
        }
        return this._images;
    }

    @Override
    public HTMLCollection getApplets() {
        if (this._applets == null) {
            this._applets = new HTMLCollectionImpl(this.getBody(), 4);
        }
        return this._applets;
    }

    @Override
    public HTMLCollection getLinks() {
        if (this._links == null) {
            this._links = new HTMLCollectionImpl(this.getBody(), 5);
        }
        return this._links;
    }

    @Override
    public HTMLCollection getForms() {
        if (this._forms == null) {
            this._forms = new HTMLCollectionImpl(this.getBody(), 2);
        }
        return this._forms;
    }

    @Override
    public HTMLCollection getAnchors() {
        if (this._anchors == null) {
            this._anchors = new HTMLCollectionImpl(this.getBody(), 1);
        }
        return this._anchors;
    }

    @Override
    public void open() {
        if (this._writer == null) {
            this._writer = new StringWriter();
        }
    }

    @Override
    public void close() {
        if (this._writer != null) {
            this._writer = null;
        }
    }

    @Override
    public void write(String text) {
        if (this._writer != null) {
            this._writer.write(text);
        }
    }

    @Override
    public void writeln(String text) {
        if (this._writer != null) {
            this._writer.write(text + "\n");
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        HTMLDocumentImpl newdoc = new HTMLDocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode((CoreDocumentImpl)newdoc, deep);
        return newdoc;
    }

    protected boolean canRenameElements(String newNamespaceURI, String newNodeName, ElementImpl el) {
        Class<? extends HTMLElementImpl> oldClass;
        if (el.getNamespaceURI() != null) {
            return newNamespaceURI != null;
        }
        Class<? extends HTMLElementImpl> newClass = _elementTypesHTML.get(newNodeName.toUpperCase(Locale.ENGLISH));
        return newClass == (oldClass = _elementTypesHTML.get(el.getTagName()));
    }

    private Element getElementById(String elementId, Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            if (elementId.equals(((Element)child).getAttribute("id"))) {
                return (Element)child;
            }
            Element result = this.getElementById(elementId, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static {
        _elementTypesHTML.put("A", HTMLAnchorElementImpl.class);
        _elementTypesHTML.put("APPLET", HTMLAppletElementImpl.class);
        _elementTypesHTML.put("AREA", HTMLAreaElementImpl.class);
        _elementTypesHTML.put("BASE", HTMLBaseElementImpl.class);
        _elementTypesHTML.put("BASEFONT", HTMLBaseFontElementImpl.class);
        _elementTypesHTML.put("BLOCKQUOTE", HTMLQuoteElementImpl.class);
        _elementTypesHTML.put("BODY", HTMLBodyElementImpl.class);
        _elementTypesHTML.put("BR", HTMLBRElementImpl.class);
        _elementTypesHTML.put("BUTTON", HTMLButtonElementImpl.class);
        _elementTypesHTML.put("DEL", HTMLModElementImpl.class);
        _elementTypesHTML.put("DIR", HTMLDirectoryElementImpl.class);
        _elementTypesHTML.put("DIV", HTMLDivElementImpl.class);
        _elementTypesHTML.put("DL", HTMLDListElementImpl.class);
        _elementTypesHTML.put("FIELDSET", HTMLFieldSetElementImpl.class);
        _elementTypesHTML.put("FONT", HTMLFontElementImpl.class);
        _elementTypesHTML.put("FORM", HTMLFormElementImpl.class);
        _elementTypesHTML.put("FRAME", HTMLFrameElementImpl.class);
        _elementTypesHTML.put("FRAMESET", HTMLFrameSetElementImpl.class);
        _elementTypesHTML.put("HEAD", HTMLHeadElementImpl.class);
        _elementTypesHTML.put("H1", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("H2", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("H3", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("H4", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("H5", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("H6", HTMLHeadingElementImpl.class);
        _elementTypesHTML.put("HR", HTMLHRElementImpl.class);
        _elementTypesHTML.put("HTML", HTMLHtmlElementImpl.class);
        _elementTypesHTML.put("IFRAME", HTMLIFrameElementImpl.class);
        _elementTypesHTML.put("IMG", HTMLImageElementImpl.class);
        _elementTypesHTML.put("INPUT", HTMLInputElementImpl.class);
        _elementTypesHTML.put("INS", HTMLModElementImpl.class);
        _elementTypesHTML.put("ISINDEX", HTMLIsIndexElementImpl.class);
        _elementTypesHTML.put("LABEL", HTMLLabelElementImpl.class);
        _elementTypesHTML.put("LEGEND", HTMLLegendElementImpl.class);
        _elementTypesHTML.put("LI", HTMLLIElementImpl.class);
        _elementTypesHTML.put("LINK", HTMLLinkElementImpl.class);
        _elementTypesHTML.put("MAP", HTMLMapElementImpl.class);
        _elementTypesHTML.put("MENU", HTMLMenuElementImpl.class);
        _elementTypesHTML.put("META", HTMLMetaElementImpl.class);
        _elementTypesHTML.put("OBJECT", HTMLObjectElementImpl.class);
        _elementTypesHTML.put("OL", HTMLOListElementImpl.class);
        _elementTypesHTML.put("OPTGROUP", HTMLOptGroupElementImpl.class);
        _elementTypesHTML.put("OPTION", HTMLOptionElementImpl.class);
        _elementTypesHTML.put("P", HTMLParagraphElementImpl.class);
        _elementTypesHTML.put("PARAM", HTMLParamElementImpl.class);
        _elementTypesHTML.put("PRE", HTMLPreElementImpl.class);
        _elementTypesHTML.put("Q", HTMLQuoteElementImpl.class);
        _elementTypesHTML.put("SCRIPT", HTMLScriptElementImpl.class);
        _elementTypesHTML.put("SELECT", HTMLSelectElementImpl.class);
        _elementTypesHTML.put("STYLE", HTMLStyleElementImpl.class);
        _elementTypesHTML.put("TABLE", HTMLTableElementImpl.class);
        _elementTypesHTML.put("CAPTION", HTMLTableCaptionElementImpl.class);
        _elementTypesHTML.put("TD", HTMLTableCellElementImpl.class);
        _elementTypesHTML.put("TH", HTMLTableCellElementImpl.class);
        _elementTypesHTML.put("COL", HTMLTableColElementImpl.class);
        _elementTypesHTML.put("COLGROUP", HTMLTableColElementImpl.class);
        _elementTypesHTML.put("TR", HTMLTableRowElementImpl.class);
        _elementTypesHTML.put("TBODY", HTMLTableSectionElementImpl.class);
        _elementTypesHTML.put("THEAD", HTMLTableSectionElementImpl.class);
        _elementTypesHTML.put("TFOOT", HTMLTableSectionElementImpl.class);
        _elementTypesHTML.put("TEXTAREA", HTMLTextAreaElementImpl.class);
        _elementTypesHTML.put("TITLE", HTMLTitleElementImpl.class);
        _elementTypesHTML.put("UL", HTMLUListElementImpl.class);
    }
}

