/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import net.sourceforge.htmlunit.cyberneko.Writer;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMParser;
import net.sourceforge.htmlunit.html.dom.HTMLDocumentImpl;
import net.sourceforge.htmlunit.xerces.xni.QName;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLDocumentFilter;
import net.sourceforge.htmlunit.xerces.xni.parser.XMLInputSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeneralTest {
    private static final String NL = System.lineSeparator();
    private static final String[] FEATURES = new String[]{"http://cyberneko.org/html/features/augmentations"};

    @Test
    public void newlineInAttributeCrLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,52](span" + NL + "Aclass value\\ncontaining a newline" + NL + "[2,23,52;2,34,63]\"spancontent" + NL + "[2,34,63;2,41,70])span" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <span class='value\r\ncontaining a newline'>spancontent</span>", new String[]{"html", "body"}, expected, FEATURES);
    }

    @Test
    public void newlineInAttributeLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,51](span" + NL + "Aclass value\\ncontaining a newline" + NL + "[2,23,51;2,34,62]\"spancontent" + NL + "[2,34,62;2,41,69])span" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <span class='value\ncontaining a newline'>spancontent</span>", new String[]{"html", "body"}, expected, FEATURES);
    }

    @Test
    public void newlineInPiCrLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,63]?instruct beforenl='content'\\n  afternl=\"content\" " + NL + "[2,23,63;3,1,74]\"more text\\n" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <?instruct beforenl='content'\r\n  afternl=\"content\" ?>more text\r\n", new String[]{"html", "body"}, expected, FEATURES);
    }

    @Test
    public void newlineInPiLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,62]?instruct beforenl='content'\\n  afternl=\"content\" " + NL + "[2,23,62;3,1,73]\"more text\\n" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <?instruct beforenl='content'\n  afternl=\"content\" ?>more text\r\n", new String[]{"html", "body"}, expected, FEATURES);
    }

    public static void doTest(String html, String[] contextStack, String expected, String ... features) throws Exception {
        DOMParser parser = new DOMParser(HTMLDocumentImpl.class);
        for (String feature : features) {
            parser.setFeature(feature, true);
        }
        if (contextStack != null) {
            parser.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", (Object)GeneralTest.toQNames(contextStack));
        }
        StringWriter out = new StringWriter();
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        StringReader sr = new StringReader(html);
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        Assertions.assertEquals((Object)expected.trim(), (Object)out.toString().trim());
    }

    private static QName[] toQNames(String[] tags) {
        QName[] qnames = new QName[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            qnames[i] = new QName(null, tags[i], null, null);
        }
        return qnames;
    }
}

