/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.StringReader;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMFragmentParser;
import net.sourceforge.htmlunit.html.dom.HTMLDocumentImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class DOMFragmentParserTest {
    @Test
    public void attrEndingWithCRAtEndOfStream() {
    }

    @Test
    public void invalidProcessingInstruction() throws Exception {
        DOMFragmentParserTest.doTest("<html><?9 ?></html>", "<HTML/>");
    }

    @Test
    public void invalidAttributeName() throws Exception {
        DOMFragmentParserTest.doTest("<html 9='id'></html>", "<HTML/>");
    }

    private static void doTest(String html, String expected) throws Exception {
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment = document.createDocumentFragment();
        InputSource source = new InputSource(new StringReader(html));
        parser.parse(source, fragment);
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        String str = writer.writeToString(fragment);
        str = str.replace("\r", "").replace("\n", "");
        String xmlDecl = "<?xml version=\"1.0\" encoding=\"UTF-16\"?>";
        Assertions.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-16\"?>" + expected), (Object)str);
    }

    public static void print(Node node, String indent) {
        System.out.println(indent + node.getClass().getName());
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DOMFragmentParserTest.print(child, indent + " ");
        }
    }

    @Test
    public void instanceReuse() throws Exception {
        String s = "<html><body><frame><frameset></frameset></html>";
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment1 = document.createDocumentFragment();
        parser.parse(new InputSource(new StringReader("<html><body><frame><frameset></frameset></html>")), fragment1);
        DocumentFragment fragment2 = document.createDocumentFragment();
        parser.parse(new InputSource(new StringReader("<html><body><frame><frameset></frameset></html>")), fragment2);
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        String str1 = writer.writeToString(fragment1);
        String str2 = writer.writeToString(fragment2);
        Assertions.assertEquals((Object)str1, (Object)str2);
    }
}

