/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.ByteArrayInputStream;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TableBodyNamespaceBugTest {
    @Test
    public void headNamespace() throws Exception {
        final int[] nbTags = new int[]{0};
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void startElement(String ns, String name, String qName, Attributes atts) {
                Assertions.assertEquals((Object)("http://www.w3.org/1999/xhtml:" + name), (Object)(ns + ":" + name));
                nbTags[0] = nbTags[0] + 1;
            }
        };
        InputSource source = new InputSource();
        source.setByteStream(new ByteArrayInputStream("<html xmlns='http://www.w3.org/1999/xhtml'><body><table><tr></tr></table></html>".getBytes()));
        HTMLConfiguration conf = new HTMLConfiguration();
        conf.setFeature("http://cyberneko.org/html/features/insert-namespaces", true);
        AbstractSAXParser parser = new AbstractSAXParser((XMLParserConfiguration)conf){};
        parser.setContentHandler((ContentHandler)handler);
        parser.parse(source);
        Assertions.assertEquals((int)6, (int)nbTags[0]);
    }
}

