/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLScanner;
import net.sourceforge.htmlunit.cyberneko.filters.DefaultFilter;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HTMLScannerTest {
    @Test
    public void isEncodingCompatible() throws Exception {
        HTMLScanner scanner = new HTMLScanner(new HTMLConfiguration());
        Assertions.assertTrue((boolean)scanner.isEncodingCompatible("ISO-8859-1", "ISO-8859-1"));
        Assertions.assertTrue((boolean)scanner.isEncodingCompatible("UTF-8", "UTF-8"));
        Assertions.assertTrue((boolean)scanner.isEncodingCompatible("UTF-16", "UTF-16"));
        Assertions.assertTrue((boolean)scanner.isEncodingCompatible("US-ASCII", "ISO-8859-1"));
        Assertions.assertTrue((boolean)scanner.isEncodingCompatible("UTF-8", "ISO-8859-1"));
        Assertions.assertFalse((boolean)scanner.isEncodingCompatible("UTF-8", "UTF-16"));
        Assertions.assertFalse((boolean)scanner.isEncodingCompatible("ISO-8859-1", "UTF-16"));
        Assertions.assertFalse((boolean)scanner.isEncodingCompatible("UTF-16", "Cp1252"));
    }

    @Test
    public void evaluateInputSource() throws Exception {
        String string = "<html><head><title>foo</title></head><body><script id='myscript'>  document.write('<style type=\"text/css\" id=\"myStyle\">');  document.write('  .nwr {white-space: nowrap;}');  document.write('</style>');  document.write('<div id=\"myDiv\"><span></span>');  document.write('</div>');</script><div><a/></div></body></html>";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<html><head><title>foo</title></head><body><script id='myscript'>  document.write('<style type=\"text/css\" id=\"myStyle\">');  document.write('  .nwr {white-space: nowrap;}');  document.write('</style>');  document.write('<div id=\"myDiv\"><span></span>');  document.write('</div>');</script><div><a/></div></body></html>"), "UTF-8");
        parser.parse(source);
        String[] expectedString = new String[]{"(html", "(head", "(title", ")title", ")head", "(body", "(script", ")script", "~inserting", "(style", "~inserting", "~inserting", ")style", "~inserting", "(div", "(span", ")span", "~inserting", ")div", "(div", "(a", ")a", ")div", ")body", ")html"};
        Assertions.assertEquals(Arrays.asList(expectedString), (Object)filter.collectedStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void locale() throws Exception {
        Locale originalLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr", "TR"));
            String string = "<html><head><title>foo</title></head><body></body></html>";
            HTMLConfiguration parser = new HTMLConfiguration();
            EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
            XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<html><head><title>foo</title></head><body></body></html>"), "UTF-8");
            parser.parse(source);
            String[] expectedString = new String[]{"(html", "(head", "(title", ")title", ")head", "(body", ")body", ")html"};
            Assertions.assertEquals((Object)Arrays.asList(expectedString).toString(), (Object)filter.collectedStrings.toString());
        }
        finally {
            Locale.setDefault(originalLocale);
        }
    }

    @Test
    public void changeEncodingWithReader() throws Exception {
        String string = "<?xml version='1.0' encoding='UTF-8'?><html><head><title>foo</title></head></body></html>";
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<?xml version='1.0' encoding='UTF-8'?><html><head><title>foo</title></head></body></html>"), "ISO8859-1");
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.parse(source);
    }

    @Test
    public void reduceToContent() throws Exception {
        XMLStringBuffer buffer = new XMLStringBuffer("<!-- hello-->");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        Assertions.assertEquals((Object)" hello", (Object)buffer.toString());
        buffer = new XMLStringBuffer("  \n <!-- hello-->\n");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        Assertions.assertEquals((Object)" hello", (Object)buffer.toString());
        buffer = new XMLStringBuffer("hello");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        Assertions.assertEquals((Object)"hello", (Object)buffer.toString());
        buffer = new XMLStringBuffer("<!-- hello");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        Assertions.assertEquals((Object)"<!-- hello", (Object)buffer.toString());
        buffer = new XMLStringBuffer("<!--->");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        Assertions.assertEquals((Object)"<!--->", (Object)buffer.toString());
    }

    @Test
    public void infiniteLoop() throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        for (int x = 0; x <= 2005; ++x) {
            buffer.append((char)(x % 10 + 48));
        }
        buffer.append("\n<noframes>- Generated in 1<1ms -->");
        HTMLConfiguration parser = new HTMLConfiguration(){

            protected HTMLScanner createDocumentScanner() {
                return new InfiniteLoopScanner();
            }
        };
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader(buffer.toString()), "UTF-8");
        parser.parse(source);
    }

    @Test
    public void elementNameNormalization() throws Exception {
        String string = "<HTML><Head><tiTLE>foo</tiTLE></hEaD><Body></BOdy></htMl>";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<HTML><Head><tiTLE>foo</tiTLE></hEaD><Body></BOdy></htMl>"), "UTF-8");
        parser.parse(source);
        String[] expectedString = new String[]{"(HTML", "(Head", "(tiTLE", ")tiTLE", ")Head", "(Body", ")Body", ")HTML"};
        Assertions.assertEquals((Object)Arrays.asList(expectedString).toString(), (Object)filter.collectedStrings.toString());
        parser = new HTMLConfiguration();
        filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"upper");
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<HTML><Head><tiTLE>foo</tiTLE></hEaD><Body></BOdy></htMl>"), "UTF-8");
        parser.parse(source);
        String[] expectedStringUpper = new String[]{"(HTML", "(HEAD", "(TITLE", ")TITLE", ")HEAD", "(BODY", ")BODY", ")HTML"};
        Assertions.assertEquals((Object)Arrays.asList(expectedStringUpper).toString(), (Object)filter.collectedStrings.toString());
        parser = new HTMLConfiguration();
        filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<HTML><Head><tiTLE>foo</tiTLE></hEaD><Body></BOdy></htMl>"), "UTF-8");
        parser.parse(source);
        String[] expectedStringLower = new String[]{"(html", "(head", "(title", ")title", ")head", "(body", ")body", ")html"};
        Assertions.assertEquals((Object)Arrays.asList(expectedStringLower).toString(), (Object)filter.collectedStrings.toString());
    }

    @Test
    public void invalidProcessingInstruction() throws Exception {
        String string = "<!--?><?a/";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<!--?><?a/"), "UTF-8");
        parser.parse(source);
        String[] expected = new String[]{"(HTML", "(head", ")head", "(body", ")body", ")html"};
        Assertions.assertEquals((Object)Arrays.asList(expected).toString(), (Object)filter.collectedStrings.toString());
    }

    @Test
    public void invalidProcessingInstruction2() throws Exception {
        String string = "<?ax\r";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<?ax\r"), "UTF-8");
        parser.parse(source);
        String[] expected = new String[]{"(HTML", "(head", ")head", "(body", ")body", ")html"};
        Assertions.assertEquals((Object)Arrays.asList(expected).toString(), (Object)filter.collectedStrings.toString());
    }

    @Test
    public void invalidProcessingInstruction3() throws Exception {
        String string = "<?a x\r";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader("<?a x\r"), "UTF-8");
        parser.parse(source);
        String[] expected = new String[]{"(HTML", "(head", ")head", "(body", ")body", ")html"};
        Assertions.assertEquals((Object)Arrays.asList(expected).toString(), (Object)filter.collectedStrings.toString());
    }

    static class InfiniteLoopScanner
    extends HTMLScanner {
        InfiniteLoopScanner() {
            super(new HTMLConfiguration());
            this.fContentScanner = new MyContentScanner();
        }

        class MyContentScanner
        extends HTMLScanner.ContentScanner {
            MyContentScanner() {
                super((HTMLScanner)InfiniteLoopScanner.this);
            }

            protected void scanComment() throws IOException {
                this.nextContent(30);
                super.scanComment();
            }
        }
    }

    private static class EvaluateInputSourceFilter
    extends DefaultFilter {
        private final List<String> collectedStrings = new ArrayList<String>();
        private static int counter = 1;
        protected HTMLConfiguration fConfiguration;

        public EvaluateInputSourceFilter(HTMLConfiguration config) {
            this.fConfiguration = config;
        }

        public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
            this.collectedStrings.add("(" + element.rawname);
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.collectedStrings.add(")" + element.rawname);
            if (element.localpart.equalsIgnoreCase("SCRIPT")) {
                this.insert("<style type=\"text/css\" id=\"myStyle\">");
                this.insert("  .nwr {white-space: nowrap;}");
                this.insert("</style>");
                this.insert("<div id=\"myDiv\"><span></span>");
                this.insert("</div>");
            }
        }

        private void insert(String string) {
            this.collectedStrings.add("~inserting");
            XMLInputSource source = new XMLInputSource(null, "myTest" + counter++, null, (Reader)new StringReader(string), "UTF-8");
            this.fConfiguration.evaluateInputSource(source);
        }
    }
}

