/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import net.sourceforge.htmlunit.cyberneko.GeneralTest;
import org.junit.jupiter.api.Test;

public class FragmentContextStackTest {
    private static final String NL = System.lineSeparator();
    private static final String[] FEATURES = new String[]{"http://cyberneko.org/html/features/balance-tags/document-fragment"};

    @Test
    public void simple() throws Exception {
        String expected = "(div" + NL + "(span" + NL + "\"hello" + NL + ")span" + NL + ")div" + NL;
        GeneralTest.doTest("<div><span>hello</span>", new String[]{"html", "body"}, expected, FEATURES);
        GeneralTest.doTest("<div><span>hello</span>", new String[]{"html"}, expected, FEATURES);
        GeneralTest.doTest("<div><span>hello</span>", new String[0], expected, FEATURES);
        GeneralTest.doTest("<div><span>hello</span>", null, expected, FEATURES);
    }

    @Test
    public void tr() throws Exception {
        String expected = "(tr" + NL + "(td" + NL + "\"hello" + NL + ")td" + NL + ")tr" + NL;
        GeneralTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table", "tbody"}, expected, FEATURES);
        expected = "(TBODY" + NL + expected + ")TBODY\n";
        GeneralTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table"}, expected, FEATURES);
        GeneralTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body"}, "\"hello", FEATURES);
    }

    @Test
    public void fragmentShouldNotCloseContextStack() throws Exception {
        String expected = "\"helloworld\n";
        GeneralTest.doTest("hello</div>world", new String[]{"html", "body", "div"}, "\"helloworld\n", FEATURES);
        GeneralTest.doTest("hello</span>world", new String[]{"html", "body", "div", "span"}, "\"helloworld\n", FEATURES);
    }

    @Test
    public void fragmentShouldNotCloseContextStackPHack() throws Exception {
        GeneralTest.doTest("<p>hello world</p>", new String[]{"html", "body", "p"}, ")null" + NL + "(p" + NL + "\"hello world" + NL + ")p", FEATURES);
        GeneralTest.doTest("<p>hello world", new String[]{"html", "body", "p"}, ")null" + NL + "(p" + NL + "\"hello world" + NL + ")p", FEATURES);
        GeneralTest.doTest("<p>hello world</p>", new String[]{"html", "body", "p", "span"}, ")null" + NL + ")null" + NL + "(p" + NL + "\"hello world" + NL + ")p", FEATURES);
    }

    @Test
    public void fragmentShouldNotCloseSelect() throws Exception {
        GeneralTest.doTest("<select><option>Two</option></select>", new String[]{"html", "body", "select"}, ")null" + NL + "(select" + NL + "(option" + NL + "\"Two" + NL + ")option" + NL + ")select", FEATURES);
    }
}

