/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLEntitiesParser;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HTMLEntitiesTest {
    @Test
    public void parseEuml() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "Euml ";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertEquals((Object)"\u00cb", (Object)parser.getMatch());
        Assertions.assertEquals((int)1, (int)parser.getRewindCount());
        Assertions.assertFalse((boolean)parser.endsWithSemicolon());
    }

    @Test
    public void parseEuml_() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "Euml; ";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertEquals((Object)"\u00cb", (Object)parser.getMatch());
        Assertions.assertEquals((int)0, (int)parser.getRewindCount());
        Assertions.assertTrue((boolean)parser.endsWithSemicolon());
    }

    @Test
    public void parseEumlX() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "EumlX";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertEquals((Object)"\u00cb", (Object)parser.getMatch());
        Assertions.assertEquals((int)1, (int)parser.getRewindCount());
        Assertions.assertFalse((boolean)parser.endsWithSemicolon());
    }

    @Test
    public void parseEumX() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "EumX";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertNull((Object)parser.getMatch());
        Assertions.assertEquals((int)4, (int)parser.getRewindCount());
        Assertions.assertFalse((boolean)parser.endsWithSemicolon());
    }

    @Test
    public void parseEuroLt() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "euro<";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertNull((Object)parser.getMatch());
        Assertions.assertEquals((int)5, (int)parser.getRewindCount());
        Assertions.assertFalse((boolean)parser.endsWithSemicolon());
    }

    @Test
    public void parseEuro() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "x80;";
        int i = 0;
        while (parser.parseNumeric((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertEquals((Object)"\u20ac", (Object)parser.getMatch());
        Assertions.assertEquals((int)0, (int)parser.getRewindCount());
    }

    @Test
    public void parseEuroMissingSemicolon() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "x80<";
        int i = 0;
        while (parser.parseNumeric((int)input.charAt(i))) {
            ++i;
        }
        Assertions.assertEquals((Object)"\u20ac", (Object)parser.getMatch());
        Assertions.assertEquals((int)1, (int)parser.getRewindCount());
    }

    @Test
    public void rewind() throws Exception {
        HTMLConfiguration htmlConfiguration = new HTMLConfiguration();
        String content = "<html blah=\"funfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfun&fin\"></html>";
        ByteArrayInputStream byteStream = new ByteArrayInputStream(content.getBytes());
        XMLInputSource inputSource = new XMLInputSource("", "", "", (InputStream)byteStream, "UTF-8");
        htmlConfiguration.parse(inputSource);
    }
}

