/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLErrorHandler;
import net.sourceforge.htmlunit.cyberneko.UTF8BOMSkipper;
import net.sourceforge.htmlunit.cyberneko.Writer;
import org.apache.xerces.impl.Version;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.opentest4j.AssertionFailedError;

public class CanonicalTest {
    private static final File dataDir = new File("src/test/resources");
    private static final File canonicalDir = new File("src/test/resources/canonical");
    private static final File outputDir = new File("target/data/output/" + Version.getVersion());

    @TestFactory
    public Iterable<DynamicTest> suite() throws Exception {
        outputDir.mkdirs();
        final ArrayList dataFiles = new ArrayList();
        dataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                if (file.isDirectory() && !"canonical".equals(name)) {
                    file.listFiles(this);
                } else if (name.startsWith("test") && name.endsWith(".html")) {
                    dataFiles.add(file);
                }
                return false;
            }
        });
        Collections.sort(dataFiles);
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (int i = 0; i < dataFiles.size(); ++i) {
            File dataFile = (File)dataFiles.get(i);
            tests.add(DynamicTest.dynamicTest((String)(dataFile.getName() + " [" + Version.getVersion() + "]"), () -> this.runTest(dataFile)));
        }
        return tests;
    }

    protected void runTest(File dataFile) throws Exception {
        block19: {
            String dataLines = CanonicalTest.getResult(dataFile);
            try {
                File nyiFile;
                File canonicalFile = new File(dataFile.getParentFile(), dataFile.getName() + ".canonical");
                if (!canonicalFile.exists()) {
                    canonicalFile = new File(canonicalDir, dataFile.getName());
                }
                if (!canonicalFile.exists()) {
                    Assertions.fail((String)("Canonical file not found for input: " + dataFile.getAbsolutePath() + ": " + dataLines));
                }
                if ((nyiFile = new File(dataFile.getParentFile(), dataFile.getName() + ".notyetimplemented")).exists()) {
                    try {
                        Assertions.assertEquals((Object)CanonicalTest.getCanonical(canonicalFile), (Object)dataLines, (String)dataFile.toString());
                        Assertions.fail((String)("test " + dataFile.getName() + "is marked as not yet implemented but already works"));
                    }
                    catch (AssertionFailedError assertionFailedError) {
                        // empty catch block
                    }
                    Assertions.assertEquals((Object)CanonicalTest.getCanonical(nyiFile), (Object)dataLines, (String)("NYI: " + dataFile.toString()));
                    break block19;
                }
                Assertions.assertEquals((Object)CanonicalTest.getCanonical(canonicalFile), (Object)dataLines, (String)dataFile.toString());
            }
            catch (AssertionFailedError e) {
                File output = new File(outputDir, dataFile.getName());
                try (PrintWriter pw = new PrintWriter(new FileOutputStream(output));){
                    pw.print(dataLines);
                }
                throw e;
            }
        }
    }

    private static String getCanonical(File infile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new UTF8BOMSkipper(new FileInputStream(infile)), "UTF-8"));){
            String line;
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    private static String getResult(File infile) throws IOException {
        try (StringWriter out = new StringWriter();){
            String line;
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
            HTMLConfiguration parser = new HTMLConfiguration();
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            String infilename = infile.toString();
            File insettings = new File(infilename + ".settings");
            if (insettings.exists()) {
                try (BufferedReader settings = new BufferedReader(new FileReader(insettings));){
                    String settingline;
                    while ((settingline = settings.readLine()) != null) {
                        StringTokenizer tokenizer = new StringTokenizer(settingline);
                        String type = tokenizer.nextToken();
                        String id = tokenizer.nextToken();
                        String value = tokenizer.nextToken();
                        if (type.equals("feature")) {
                            parser.setFeature(id, value.equals("true"));
                            if (!"http://cyberneko.org/html/features/report-errors".equals(id)) continue;
                            parser.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(out));
                            continue;
                        }
                        parser.setProperty(id, (Object)value);
                    }
                }
            }
            parser.parse(new XMLInputSource(null, infilename, null));
            BufferedReader reader = new BufferedReader(new StringReader(out.toString()));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

