/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.TestParser;
import org.apache.xerces.xni.parser.XMLInputSource;

public class HTMLTagBalancingListenerTest
extends TestCase {
    public void testIgnoredTags() throws Exception {
        String string = "<html><head><title>foo</title></head><body><body onload='alert(123)'><div><form action='foo'>  <input name='text1'/></div></form></body></html>";
        TestParser parser = new TestParser();
        StringReader sr = new StringReader("<html><head><title>foo</title></head><body><body onload='alert(123)'><div><form action='foo'>  <input name='text1'/></div></form></body></html>");
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        String[] expectedMessages = new String[]{"start HTML", "start HEAD", "start TITLE", "end TITLE", "end HEAD", "start BODY", "ignored start BODY", "start DIV", "start FORM", "start INPUT", "end INPUT", "end FORM", "end DIV", "ignored end FORM", "end BODY", "end HTML"};
        HTMLTagBalancingListenerTest.assertEquals((String)Arrays.asList(expectedMessages).toString(), (String)parser.messages.toString());
    }

    public void testReuse() throws Exception {
        String string = "<head><title>title</title></head><body><div>hello</div></body>";
        TestParser parser = new TestParser();
        StringReader sr = new StringReader("<head><title>title</title></head><body><div>hello</div></body>");
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        String[] expectedMessages = new String[]{"start HTML", "start HEAD", "start TITLE", "end TITLE", "end HEAD", "start BODY", "start DIV", "end DIV", "end BODY", "end HTML"};
        HTMLTagBalancingListenerTest.assertEquals((String)Arrays.asList(expectedMessages).toString(), (String)parser.messages.toString());
        parser.messages.clear();
        parser.parse(new XMLInputSource(null, "foo", null, (Reader)new StringReader("<head><title>title</title></head><body><div>hello</div></body>"), null));
        HTMLTagBalancingListenerTest.assertEquals((String)Arrays.asList(expectedMessages).toString(), (String)parser.messages.toString());
    }
}

