/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLErrorHandler;
import net.sourceforge.htmlunit.cyberneko.UTF8BOMSkipper;
import net.sourceforge.htmlunit.cyberneko.Writer;
import net.sourceforge.htmlunit.cyberneko.xercesbridge.XercesBridge;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class CanonicalTest
extends TestCase {
    private static final File dataDir = new File("src/test/resources");
    private static final File canonicalDir = new File("src/test/resources/canonical");
    private static final File outputDir = new File("target/data/output/" + XercesBridge.getInstance().getVersion());
    private File dataFile;

    public static Test suite() throws Exception {
        System.out.println(canonicalDir.getAbsolutePath());
        outputDir.mkdirs();
        TestSuite suite = new TestSuite();
        final ArrayList dataFiles = new ArrayList();
        dataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                if (file.isDirectory() && !"canonical".equals(name)) {
                    file.listFiles(this);
                } else if (name.startsWith("test") && name.endsWith(".html")) {
                    dataFiles.add(file);
                }
                return false;
            }
        });
        Collections.sort(dataFiles);
        for (int i = 0; i < dataFiles.size(); ++i) {
            suite.addTest((Test)new CanonicalTest((File)dataFiles.get(i)));
        }
        return suite;
    }

    CanonicalTest(File dataFile) throws Exception {
        super(dataFile.getName() + " [" + XercesBridge.getInstance().getVersion() + "]");
        this.dataFile = dataFile;
    }

    protected void runTest() throws Exception {
        String dataLines = this.getResult(this.dataFile);
        try {
            File canonicalFile = new File(this.dataFile.getParentFile(), this.dataFile.getName() + ".canonical");
            if (!canonicalFile.exists()) {
                canonicalFile = new File(canonicalDir, this.dataFile.getName());
            }
            if (!canonicalFile.exists()) {
                CanonicalTest.fail((String)("Canonical file not found for input: " + this.dataFile.getAbsolutePath() + ": " + dataLines));
            }
            String canonicalLines = this.getCanonical(canonicalFile);
            CanonicalTest.assertEquals((String)this.dataFile.toString(), (String)canonicalLines, (String)dataLines);
        }
        catch (AssertionFailedError e) {
            File output = new File(outputDir, this.dataFile.getName());
            PrintWriter pw = new PrintWriter(new FileOutputStream(output));
            pw.print(dataLines);
            pw.close();
            throw e;
        }
    }

    private String getCanonical(File infile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new UTF8BOMSkipper(new FileInputStream(infile)), "UTF-8"));){
            String line;
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResult(File infile) throws IOException {
        String line;
        try (StringWriter out = new StringWriter();){
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
            HTMLConfiguration parser = new HTMLConfiguration();
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            String infilename = infile.toString();
            File insettings = new File(infilename + ".settings");
            if (insettings.exists()) {
                String settingline;
                BufferedReader settings = new BufferedReader(new FileReader(insettings));
                while ((settingline = settings.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(settingline);
                    String type = tokenizer.nextToken();
                    String id = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    if (type.equals("feature")) {
                        parser.setFeature(id, value.equals("true"));
                        if (!"http://cyberneko.org/html/features/report-errors".equals(id)) continue;
                        parser.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(out));
                        continue;
                    }
                    parser.setProperty(id, (Object)value);
                }
                settings.close();
            }
            parser.parse(new XMLInputSource(null, infilename, null));
        }
        BufferedReader reader = new BufferedReader(new StringReader(out.toString()));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }
}

