/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLScanner;
import net.sourceforge.htmlunit.cyberneko.filters.DefaultFilter;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;

public class HTMLScannerTest
extends TestCase {
    public void testisEncodingCompatible() throws Exception {
        HTMLScanner scanner = new HTMLScanner(new HTMLConfiguration());
        HTMLScannerTest.assertTrue((boolean)scanner.isEncodingCompatible("ISO-8859-1", "ISO-8859-1"));
        HTMLScannerTest.assertTrue((boolean)scanner.isEncodingCompatible("UTF-8", "UTF-8"));
        HTMLScannerTest.assertTrue((boolean)scanner.isEncodingCompatible("UTF-16", "UTF-16"));
        HTMLScannerTest.assertTrue((boolean)scanner.isEncodingCompatible("US-ASCII", "ISO-8859-1"));
        HTMLScannerTest.assertTrue((boolean)scanner.isEncodingCompatible("UTF-8", "ISO-8859-1"));
        HTMLScannerTest.assertFalse((boolean)scanner.isEncodingCompatible("UTF-8", "UTF-16"));
        HTMLScannerTest.assertFalse((boolean)scanner.isEncodingCompatible("ISO-8859-1", "UTF-16"));
        HTMLScannerTest.assertFalse((boolean)scanner.isEncodingCompatible("UTF-16", "Cp1252"));
    }

    public void testEvaluateInputSource() throws Exception {
        String string = "<html><head><title>foo</title></head><body><script id='myscript'>  document.write('<style type=\"text/css\" id=\"myStyle\">');  document.write('  .nwr {white-space: nowrap;}');  document.write('</style>');  document.write('<div id=\"myDiv\"><span></span>');  document.write('</div>');</script><div><a/></div></body></html>";
        HTMLConfiguration parser = new HTMLConfiguration();
        EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader(string), "UTF-8");
        parser.parse(source);
        String[] expectedString = new String[]{"(HTML", "(HEAD", "(TITLE", ")TITLE", ")HEAD", "(BODY", "(SCRIPT", ")SCRIPT", "~inserting", "(STYLE", "~inserting", "~inserting", ")STYLE", "~inserting", "(DIV", "(SPAN", ")SPAN", "~inserting", ")DIV", "(DIV", "(A", ")A", ")DIV", ")BODY", ")HTML"};
        HTMLScannerTest.assertEquals(Arrays.asList(expectedString), (Object)filter.collectedStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocale() throws Exception {
        Locale originalLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr", "TR"));
            String string = "<html><head><title>foo</title></head><body></body></html>";
            HTMLConfiguration parser = new HTMLConfiguration();
            EvaluateInputSourceFilter filter = new EvaluateInputSourceFilter(parser);
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{filter});
            XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader(string), "UTF-8");
            parser.parse(source);
            String[] expectedString = new String[]{"(HTML", "(HEAD", "(TITLE", ")TITLE", ")HEAD", "(BODY", ")BODY", ")HTML"};
            HTMLScannerTest.assertEquals((String)Arrays.asList(expectedString).toString(), (String)filter.collectedStrings.toString());
        }
        finally {
            Locale.setDefault(originalLocale);
        }
    }

    public void testChangeEncodingWithReader() throws Exception {
        String string = "<?xml version='1.0' encoding='UTF-8'?><html><head><title>foo</title></head></body></html>";
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader(string), "ISO8859-1");
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.parse(source);
    }

    public void testReduceToContent() throws Exception {
        XMLStringBuffer buffer = new XMLStringBuffer("<!-- hello-->");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        HTMLScannerTest.assertEquals((String)" hello", (String)buffer.toString());
        buffer = new XMLStringBuffer("  \n <!-- hello-->\n");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        HTMLScannerTest.assertEquals((String)" hello", (String)buffer.toString());
        buffer = new XMLStringBuffer("hello");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        HTMLScannerTest.assertEquals((String)"hello", (String)buffer.toString());
        buffer = new XMLStringBuffer("<!-- hello");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        HTMLScannerTest.assertEquals((String)"<!-- hello", (String)buffer.toString());
        buffer = new XMLStringBuffer("<!--->");
        HTMLScanner.reduceToContent((XMLStringBuffer)buffer, (String)"<!--", (String)"-->");
        HTMLScannerTest.assertEquals((String)"<!--->", (String)buffer.toString());
    }

    public void testInfiniteLoop() throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        for (int x = 0; x <= 2005; ++x) {
            buffer.append((char)(x % 10 + 48));
        }
        buffer.append("\n<noframes>- Generated in 1<1ms -->");
        HTMLConfiguration parser = new HTMLConfiguration(){

            protected HTMLScanner createDocumentScanner() {
                return new InfiniteLoopScanner();
            }
        };
        XMLInputSource source = new XMLInputSource(null, "myTest", null, (Reader)new StringReader(buffer.toString()), "UTF-8");
        parser.parse(source);
    }

    static class InfiniteLoopScanner
    extends HTMLScanner {
        InfiniteLoopScanner() {
            super(new HTMLConfiguration());
            this.fContentScanner = new MyContentScanner();
        }

        class MyContentScanner
        extends HTMLScanner.ContentScanner {
            MyContentScanner() {
                super((HTMLScanner)InfiniteLoopScanner.this);
            }

            protected void scanComment() throws IOException {
                this.nextContent(30);
                super.scanComment();
            }
        }
    }

    private static class EvaluateInputSourceFilter
    extends DefaultFilter {
        private List<String> collectedStrings = new ArrayList<String>();
        private static int counter = 1;
        protected HTMLConfiguration fConfiguration;

        public EvaluateInputSourceFilter(HTMLConfiguration config) {
            this.fConfiguration = config;
        }

        public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
            this.collectedStrings.add("(" + element.rawname);
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.collectedStrings.add(")" + element.rawname);
            if (element.localpart.equals("SCRIPT")) {
                this.insert("<style type=\"text/css\" id=\"myStyle\">");
                this.insert("  .nwr {white-space: nowrap;}");
                this.insert("</style>");
                this.insert("<div id=\"myDiv\"><span></span>");
                this.insert("</div>");
            }
        }

        private void insert(String string) {
            this.collectedStrings.add("~inserting");
            XMLInputSource source = new XMLInputSource(null, "myTest" + counter++, null, (Reader)new StringReader(string), "UTF-8");
            this.fConfiguration.evaluateInputSource(source);
        }
    }
}

