/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.Writer;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMParser;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;

public class FragmentContextStackTest
extends TestCase {
    private static final String NL = System.lineSeparator();

    public void testSimple() throws Exception {
        String expected = "(DIV" + NL + "(SPAN" + NL + "\"hello" + NL + ")SPAN" + NL + ")DIV" + NL;
        this.doTest("<div><span>hello</span>", new String[]{"html", "body"}, expected);
        this.doTest("<div><span>hello</span>", new String[]{"html"}, expected);
        this.doTest("<div><span>hello</span>", new String[0], expected);
        this.doTest("<div><span>hello</span>", null, expected);
    }

    public void testTR() throws Exception {
        String expected = "(TR" + NL + "(TD" + NL + "\"hello" + NL + ")TD" + NL + ")TR" + NL;
        this.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table", "tbody"}, expected);
        expected = "(TBODY" + NL + expected + ")TBODY\n";
        this.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table"}, expected);
        this.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body"}, "\"hello");
    }

    public void testFragmentShouldNotCloseContextStack() throws Exception {
        String expected = "\"helloworld\n";
        this.doTest("hello</div>world", new String[]{"html", "body", "div"}, expected);
        this.doTest("hello</span>world", new String[]{"html", "body", "div", "span"}, expected);
    }

    private void doTest(String html, String[] contextStack, String expected) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        if (contextStack != null) {
            parser.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", (Object)this.toQNames(contextStack));
        }
        StringWriter out = new StringWriter();
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        StringReader sr = new StringReader(html);
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        FragmentContextStackTest.assertEquals((String)expected.trim(), (String)out.toString().trim());
    }

    private QName[] toQNames(String[] tags) {
        QName[] qnames = new QName[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            qnames[i] = new QName(null, tags[i], null, null);
        }
        return qnames;
    }
}

