/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.ByteArrayInputStream;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class HeadNamespaceBug
extends TestCase {
    public void testHeadNamespace() throws Exception {
        final int[] nbTags = new int[]{0};
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void startElement(String ns, String name, String qName, Attributes atts) {
                TestCase.assertEquals((String)("http://www.w3.org/1999/xhtml:" + name), (String)(ns + ":" + name));
                nbTags[0] = nbTags[0] + 1;
            }
        };
        InputSource source = new InputSource();
        source.setByteStream(new ByteArrayInputStream("<html xmlns='http://www.w3.org/1999/xhtml'><body/></html>".getBytes()));
        HTMLConfiguration conf = new HTMLConfiguration();
        conf.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        conf.setFeature("http://cyberneko.org/html/features/insert-namespaces", true);
        AbstractSAXParser parser = new AbstractSAXParser((XMLParserConfiguration)conf){};
        parser.setContentHandler((ContentHandler)handler);
        parser.parse(source);
        HeadNamespaceBug.assertEquals((int)3, (int)nbTags[0]);
    }
}

