/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript;

import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "ArrayIterator";
    private Scriptable arrayLike;
    private int index;

    static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeArrayIterator(), ITERATOR_TAG);
    }

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scope, Scriptable arrayLike) {
        super(scope);
        this.index = 0;
        this.arrayLike = arrayLike;
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return (long)this.index >= NativeArray.getLengthProperty(cx, this.arrayLike);
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        Object value;
        if ((value = this.arrayLike.get(this.index++, this.arrayLike)) == ScriptableObject.NOT_FOUND) {
            value = Undefined.instance;
        }
        return value;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

