/*
 * DynamicReports - Free Java reporting library for creating reports dynamically
 *
 * Copyright (C) 2010 - 2018 Ricardo Mariaca and the Dynamic Reports Contributors
 *
 * This file is part of DynamicReports.
 *
 * DynamicReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DynamicReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with DynamicReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.dynamicreports.googlecharts.jasper;

import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ElementIconConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRImageLoader;

/**
 * <p>GoogleChartsDesignConverter class.</p>
 *
 * @author Ricardo Mariaca
 * 
 */
public class GoogleChartsDesignConverter extends ElementIconConverter implements ComponentDesignConverter {

    /**
     * <p>Constructor for GoogleChartsDesignConverter.</p>
     */
    public GoogleChartsDesignConverter() {
        super(JRImageLoader.SUBREPORT_IMAGE_RESOURCE);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        return convert(reportConverter, (JRElement) element);
    }
}
