/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ccxjc.it;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import net.sourceforge.ccxjc.it.model.priv.collections.valueclass.ccxjcit.SimpleTypeAttributes;
import org.apache.commons.lang.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeAttributesCollectionsTest {
    private static final String CCXJC_NS = "http://sourceforge.net/ccxjc/it";
    private XMLGregorianCalendar testCalendar;
    private Duration testDuration;
    private byte[] testBytes;
    private List<String> testEntities;
    private List<Object> testIdRefs;
    private List<String> testTokens;
    private QName testQName;

    public XMLGregorianCalendar getTestCalendar() throws DatatypeConfigurationException {
        if (this.testCalendar == null) {
            this.testCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        }
        return this.testCalendar;
    }

    public Duration getTestDuration() throws DatatypeConfigurationException {
        if (this.testDuration == null) {
            this.testDuration = DatatypeFactory.newInstance().newDuration(1000L);
        }
        return this.testDuration;
    }

    public byte[] getTestBytes() {
        if (this.testBytes == null) {
            this.testBytes = new byte[256];
            for (int i = 255; i >= 0; --i) {
                this.testBytes[i] = (byte)i;
            }
        }
        return this.testBytes;
    }

    public List<String> getTestEntities() {
        if (this.testEntities == null) {
            this.testEntities = Arrays.asList("ENTITY 1", "ENTITY 2", "ENTITY 3");
        }
        return this.testEntities;
    }

    public List<Object> getTestIdRefs() {
        if (this.testIdRefs == null) {
            this.testIdRefs = Arrays.asList("ID");
        }
        return this.testIdRefs;
    }

    public List<String> getTestTokens() {
        if (this.testTokens == null) {
            this.testTokens = Arrays.asList("NMTOKEN 1", "NMTOKEN 2", "NMTOKEN 3");
        }
        return this.testTokens;
    }

    public QName getTestQName() {
        if (this.testQName == null) {
            this.testQName = new QName(CCXJC_NS, "ID");
        }
        return this.testQName;
    }

    public void assertTestBytes(byte[] bytes) {
        Assert.assertTrue((boolean)Arrays.equals(this.getTestBytes(), bytes));
    }

    public SimpleTypeAttributes getTestSimpleTypeAttributes() throws DatatypeConfigurationException {
        SimpleTypeAttributes t = new SimpleTypeAttributes();
        t.setAnySimpleType("any");
        t.setAnyURI("anyURI");
        t.setBase64Binary(this.getTestBytes());
        t.setBoolean(true);
        t.setByte((byte)1);
        t.setDate(this.getTestCalendar());
        t.setDateTime(this.getTestCalendar());
        t.setDecimal(BigDecimal.TEN);
        t.setDouble(100.0);
        t.setDuration(this.getTestDuration());
        t.setENTITY("ENTITY");
        t.setFloat(100.0f);
        t.setGDay(this.getTestCalendar());
        t.setGMonth(this.getTestCalendar());
        t.setGMonthDay(this.getTestCalendar());
        t.setGYear(this.getTestCalendar());
        t.setGYearMonth(this.getTestCalendar());
        t.setHexBinary(this.getTestBytes());
        t.setID("ID");
        t.setIDREF("ID");
        t.setInt(100);
        t.setInteger(BigInteger.TEN);
        t.setLanguage("en");
        t.setLong(100L);
        t.setNCName("NCName");
        t.setNMTOKEN("NMTOKEN");
        t.setNOTATION(this.getTestQName());
        t.setName("name");
        t.setNegativeInteger(BigInteger.valueOf(-100L));
        t.setNonNegativeInteger(BigInteger.TEN);
        t.setNonPositiveInteger(BigInteger.valueOf(-100L));
        t.setNormalizedString("normalized");
        t.setPositiveInteger(BigInteger.TEN);
        t.setQName(this.getTestQName());
        t.setShort((short)100);
        t.setString("String");
        t.setTime(DatatypeFactory.newInstance().newXMLGregorianCalendar());
        t.setToken("Token");
        t.setUnsignedByte((short)100);
        t.setUnsignedInt(100L);
        t.setUnsignedLong(BigInteger.TEN);
        t.setUnsignedShort(100);
        t.getENTITIES().addAll(this.getTestEntities());
        t.getIDREFS().addAll(this.getTestIdRefs());
        t.getNMTOKENS().addAll(this.getTestTokens());
        return t;
    }

    public void assertTestSimpleTypeAttributes(SimpleTypeAttributes a) throws DatatypeConfigurationException {
        Assert.assertEquals((String)"any", (String)a.getAnySimpleType());
        Assert.assertEquals((String)"anyURI", (String)a.getAnyURI());
        this.assertTestBytes(a.getBase64Binary());
        Assert.assertEquals((boolean)true, (boolean)a.isBoolean());
        Assert.assertEquals((int)1, (int)a.getByte());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getDate());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getDateTime());
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)a.getDecimal());
        Assert.assertEquals((Object)100.0, (Object)a.getDouble());
        Assert.assertEquals((Object)this.getTestDuration(), (Object)a.getDuration());
        Assert.assertEquals(this.getTestEntities(), a.getENTITIES());
        Assert.assertEquals((String)"ENTITY", (String)a.getENTITY());
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(a.getFloat()));
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getGDay());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getGMonth());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getGMonthDay());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getGYear());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getGYearMonth());
        this.assertTestBytes(a.getHexBinary());
        Assert.assertEquals((String)"ID", (String)a.getID());
        Assert.assertEquals((Object)"ID", (Object)a.getIDREF());
        Assert.assertEquals(this.getTestIdRefs(), a.getIDREFS());
        Assert.assertEquals((int)100, (int)a.getInt());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)a.getInteger());
        Assert.assertEquals((String)"en", (String)a.getLanguage());
        Assert.assertEquals((long)100L, (long)a.getLong());
        Assert.assertEquals((String)"NCName", (String)a.getNCName());
        Assert.assertEquals((String)"NMTOKEN", (String)a.getNMTOKEN());
        Assert.assertEquals(this.getTestTokens(), a.getNMTOKENS());
        Assert.assertEquals((Object)this.getTestQName(), (Object)a.getNOTATION());
        Assert.assertEquals((String)"name", (String)a.getName());
        Assert.assertEquals((Object)BigInteger.valueOf(-100L), (Object)a.getNegativeInteger());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)a.getNonNegativeInteger());
        Assert.assertEquals((Object)BigInteger.valueOf(-100L), (Object)a.getNonPositiveInteger());
        Assert.assertEquals((String)"normalized", (String)a.getNormalizedString());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)a.getPositiveInteger());
        Assert.assertEquals((Object)this.getTestQName(), (Object)a.getQName());
        Assert.assertEquals((int)100, (int)a.getShort());
        Assert.assertEquals((String)"String", (String)a.getString());
        Assert.assertEquals((Object)this.getTestCalendar(), (Object)a.getTime());
        Assert.assertEquals((String)"Token", (String)a.getToken());
        Assert.assertEquals((int)100, (int)a.getUnsignedByte());
        Assert.assertEquals((long)100L, (long)a.getUnsignedInt());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)a.getUnsignedLong());
        Assert.assertEquals((int)100, (int)a.getUnsignedShort());
    }

    public void testSimpleTypeAttributesNull() throws Exception {
        new SimpleTypeAttributes(null);
    }

    public void testSimpleTypeAttributesDefaults() throws Exception {
        new SimpleTypeAttributes(new SimpleTypeAttributes());
    }

    public void testSimpleTypeAttributes() throws Exception {
        this.assertTestSimpleTypeAttributes(new SimpleTypeAttributes(this.getTestSimpleTypeAttributes()));
    }

    public void testSerializable() throws Exception {
        int runs = 100000;
        System.gc();
        System.gc();
        System.gc();
        SimpleTypeAttributes a = this.getTestSimpleTypeAttributes();
        long start = System.currentTimeMillis();
        for (int i = 100000; i >= 0; --i) {
            this.assertTestSimpleTypeAttributes((SimpleTypeAttributes)SerializationUtils.clone((Serializable)a));
        }
        long serializableMillis = System.currentTimeMillis() - start;
        System.gc();
        System.gc();
        System.gc();
        start = System.currentTimeMillis();
        for (int i = 100000; i >= 0; --i) {
            this.assertTestSimpleTypeAttributes((SimpleTypeAttributes)a.copyTo(null));
        }
        long jaxbMillis = System.currentTimeMillis() - start;
        System.gc();
        System.gc();
        System.gc();
        start = System.currentTimeMillis();
        for (int i = 100000; i >= 0; --i) {
            this.assertTestSimpleTypeAttributes(new SimpleTypeAttributes(a));
        }
        long copyMillis = System.currentTimeMillis() - start;
        System.gc();
        System.gc();
        System.gc();
        System.out.println("Creating 100000 copies using serialization took " + serializableMillis + "ms. (100%)");
        System.out.println("Creating 100000 copies using jaxb2_commons took " + jaxbMillis + "ms. (" + 100L * jaxbMillis / serializableMillis + "%)");
        System.out.println("Creating 100000 copies using copy constructor took " + copyMillis + "ms. (" + 100L * copyMillis / serializableMillis + "%)");
        Assert.assertTrue((copyMillis < serializableMillis ? 1 : 0) != 0);
    }
}

