/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.booter.BasherBooter;
import net.sourceforge.basher.booter.BasherForkConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.DirectoryScanner;

public class BasherMojo
extends AbstractMojo {
    private File reportsDirectory;
    private List remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private ArtifactResolver artifactResolver;
    private Map pluginArtifactMap;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private File classesDirectory;
    private File buildDirectory;
    private List classpathElements;
    private List additionalClasspathElements;
    private List<String> includes;
    private List<String> excludes;
    private Properties systemProperties;
    private Properties originalSystemProperties;
    private List<BasherContext> basherContexts = new ArrayList<BasherContext>();
    private String profiler;
    private String activeBasherContext;
    protected MavenProject project;
    private String forkMode;
    private String jvm;
    private Boolean useSystemClassLoader;
    private boolean useManifestOnlyJar;
    private String debugForkedProcess;
    private File workingDirectory;
    private File basedir;
    private String argLine;
    private Map environmentVariables = new HashMap();
    private boolean enableAssertions;
    private MavenSession session;
    private int processTimeOut = 0;
    private boolean awaitShutdownEvent = false;

    public void execute() throws MojoExecutionException {
        try {
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            if (this.excludes.isEmpty()) {
                this.excludes.add("**/*$*");
            }
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            if (this.includes.isEmpty()) {
                this.includes.add("**/*Task.java");
                this.includes.add("**/Task*.java");
            }
            BasherBooter basherBooter = new BasherBooter();
            Artifact basherBooterArtifact = (Artifact)this.pluginArtifactMap.get("net.sourceforge.basher:basher-booter");
            if (basherBooterArtifact == null) {
                throw new MojoExecutionException("Unable to locate basher-booter in the list of plugin artifacts");
            }
            this.addArtifact(basherBooter, basherBooterArtifact);
            if (!this.project.getBuild().getOutputDirectory().equals(this.classesDirectory.getAbsolutePath())) {
                this.classpathElements.remove(this.project.getBuild().getOutputDirectory());
                this.classpathElements.add(this.classesDirectory.getAbsolutePath());
            }
            if (!this.project.getBuild().getTestOutputDirectory().equals(this.buildDirectory.getAbsolutePath())) {
                this.classpathElements.remove(this.project.getBuild().getTestOutputDirectory());
                this.classpathElements.add(this.buildDirectory.getAbsolutePath());
            }
            this.getLog().debug((CharSequence)"Basher ClassPaths: ");
            for (String classpathElement : this.classpathElements) {
                this.getLog().debug((CharSequence)("  " + classpathElement));
                basherBooter.addClassPathUrl(classpathElement);
            }
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in basher-plugin: " + tc));
                if ("never".equals(this.forkMode)) {
                    this.forkMode = "once";
                }
                if (this.jvm != null) {
                    this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.jvm));
                } else {
                    this.jvm = tc.findTool("java");
                }
            }
            if (this.additionalClasspathElements != null) {
                for (String classpathElement : this.additionalClasspathElements) {
                    this.getLog().debug((CharSequence)("  " + classpathElement));
                    basherBooter.addClassPathUrl(classpathElement);
                }
            }
            BasherForkConfiguration fork = new BasherForkConfiguration();
            fork.setForkMode(this.forkMode);
            this.processSystemProperties(!fork.isForking());
            DirectoryScanner directoryScanner = new DirectoryScanner();
            List list = this.project.getTestCompileSourceRoots();
            for (String compileSourceRoot : list) {
                directoryScanner.setBasedir(compileSourceRoot);
                directoryScanner.setIncludes(this.includes.toArray(new String[this.includes.size()]));
                directoryScanner.setExcludes(this.excludes.toArray(new String[this.excludes.size()]));
            }
            directoryScanner.scan();
            String[] includedFiles = directoryScanner.getIncludedFiles();
            basherBooter.setIncludedFiles(includedFiles);
            if (fork.isForking()) {
                List<String> args;
                this.getLog().info((CharSequence)"Initiating forking run");
                this.useSystemClassLoader = this.useSystemClassLoader == null ? Boolean.TRUE : this.useSystemClassLoader;
                fork.setUseSystemClassLoader(this.useSystemClassLoader.booleanValue());
                fork.setUseManifestOnlyJar(this.useManifestOnlyJar);
                fork.setSystemProperties(this.systemProperties);
                if ("true".equals(this.debugForkedProcess)) {
                    this.debugForkedProcess = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
                }
                if ("yourkit".equals(this.profiler)) {
                    this.profiler = "-agentlib:yjpagent";
                } else if ("none".equals(this.profiler)) {
                    this.profiler = null;
                }
                if (this.profiler != null) {
                    fork.setProfileLine(this.profiler);
                }
                fork.setDebugLine(this.debugForkedProcess);
                if (this.jvm == null || "".equals(this.jvm)) {
                    this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                    this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
                }
                fork.setJvmExecutable(this.jvm);
                if (this.workingDirectory != null) {
                    fork.setWorkingDirectory(this.workingDirectory);
                } else {
                    fork.setWorkingDirectory(this.basedir);
                }
                fork.setArgLine(this.argLine);
                fork.setEnvironmentVariables(this.environmentVariables);
                if (this.getLog().isDebugEnabled()) {
                    fork.setDebug(true);
                }
                if (this.argLine != null && ((args = Arrays.asList(this.argLine.split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                    this.enableAssertions = false;
                }
            }
            basherBooter.setFailIfNoTasks(Boolean.FALSE.booleanValue());
            basherBooter.setForkedProcessTimeoutInSeconds(this.processTimeOut);
            basherBooter.setRedirectTasksOutputToFile(false);
            basherBooter.setForkConfiguration(fork);
            basherBooter.setEnableAssertions(this.enableAssertions);
            basherBooter.setBasherContexts(this.basherContexts);
            basherBooter.setActiveBasherContext(this.activeBasherContext);
            basherBooter.setReportsDirectory(this.reportsDirectory);
            basherBooter.setAwaitShutdownEvent(this.awaitShutdownEvent);
            int result = basherBooter.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    protected void processSystemProperties(boolean setInSystem) {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        Properties userSpecifiedProperties = (Properties)this.session.getExecutionProperties().clone();
        userSpecifiedProperties.putAll((Map<?, ?>)this.systemProperties);
        this.systemProperties.setProperty("basedir", this.basedir.getAbsolutePath());
        this.systemProperties.setProperty("user.dir", this.workingDirectory.getAbsolutePath());
        this.systemProperties.setProperty("localRepository", this.localRepository.getBasedir());
        if (setInSystem) {
            for (String string : this.systemProperties.keySet()) {
                String value = this.systemProperties.getProperty(string);
                System.setProperty(string, value);
            }
        }
    }

    private void addArtifact(BasherBooter basherBooter, Artifact basherArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, basherArtifact);
        for (Artifact artifact : result.getArtifacts()) {
            this.getLog().debug((CharSequence)("Adding to basher booter classpath: " + artifact.getFile().getAbsolutePath()));
            basherBooter.addBasherBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
    }
}

