/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.tasks;

import net.sourceforge.basher.TaskFailedException;
import net.sourceforge.basher.TaskNotRunException;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class ATestTask extends AbstractTask
{
    public final static NullPointerException EXCEPTION = new NullPointerException("failure");

    private String _name;
    private boolean _failWithError;
    private boolean _dontRun;
    private int _sleepTime;

    public void setDontRun(final boolean dontRun)
    {
        _dontRun = dontRun;
    }

    public void setFailWithError(final boolean failWithError)
    {
        _failWithError = failWithError;
    }

    public ATestTask(String name)
    {
        _name = name;
    }

    public ATestTask()
    {
        _name = "net.sourceforge.basher.tasks.ATestTask";
    }

    public ATestTask(int sleepTime)
    {
        _name = "net.sourceforge.basher.tasks.ATestTask";
        _sleepTime = sleepTime;
    }

    public void doExecuteTask() throws Throwable
    {
        if (_failWithError)
        {
            throw new TaskFailedException("forced failure", EXCEPTION);
        }
        if (_dontRun)
        {
            throw new TaskNotRunException("forced not run");
        }

        if (_sleepTime != 0)
        {
            Thread.sleep(_sleepTime);
        }
    }

    public String getName()
    {
        return _name;
    }

    public int getMaxTime()
    {
        return 0;
    }
}
