/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.tasks;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class ATestAbstractTask extends AbstractTask
{
    private boolean _fail;
    private boolean _failWithException;
    private boolean _dontRun;


    public void setFailWithException(final boolean failWithException)
    {
        _failWithException = failWithException;
    }

    public void setFail(final boolean fail)
    {
        _fail = fail;
    }

    public void setDontRun(final boolean dontRun)
    {
        _dontRun = dontRun;
    }

    protected void doExecuteTask() throws Throwable
    {
        if (_dontRun)
        {
            notRun("forced not run", null);
        }

        if (_failWithException)
        {
            failed("forced not failed", new NullPointerException("null"));
        }

        if (_fail)
        {
            failed("forced not failed");
        }

    }
}
