/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import net.sourceforge.basher.BasherTestCase;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TestTimeSourceImpl
        extends BasherTestCase
{

    public void testSimple()
    {
        TimeSourceImpl timeSourceImpl = new TimeSourceImpl();

        long startTime = timeSourceImpl.getStartTime();

        assertTrue("Invalid start time", startTime > 0);

        sleep(50);
        long elapsed1 = timeSourceImpl.getElapsedTime();
        sleep(50);
        long elapsed2 = timeSourceImpl.getElapsedTime();

        assertTrue("Invalid elapsed time", elapsed1 > 0);
        assertTrue("Invalid elapsed time", elapsed2 > elapsed1);

        long currentTime = timeSourceImpl.getCurrentTime();
        assertTrue("Invalid current time", currentTime > 0);


    }

    public void testReset()
    {
        TimeSourceImpl timeSourceImpl = new TimeSourceImpl();

        long startTime = (long) timeSourceImpl.getStartTime();
        sleep(100);
        timeSourceImpl.reset();
        long startTime2 = (long) timeSourceImpl.getStartTime();
        assertTrue("Invalid start time after reset", startTime != startTime2);


    }


}
