package net.sourceforge.basher.internal.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import junit.framework.TestCase;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.Phase;
import org.ops4j.gaderian.service.impl.ClassFactoryImpl;
import org.apache.commons.logging.LogFactory;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestTaskDecoratorImpl extends TestCase
{
    public TaskDecoratorImpl _taskDecoratorImpl;


    public void testDetermineExecuteMethodSingleAnnotation()
    {
        final Task task = _taskDecoratorImpl.decorateInstance(new SingleExecutionMethodAnnotated());
        assertNotNull(task);
    }

    public void testFullyAnnotatedClass()
    {
        final Task task = _taskDecoratorImpl.decorateInstance(new FullyAnnotatedClass());
        assertNotNull(task);
        assertEquals("bad name", "TestName", task.getName());
        assertEquals("bad intertia", 1.3F, task.getInertia());
        assertEquals("bad max invocations", 10, task.getMaxInvocations());
        assertEquals("bad max time", 199, task.getMaxTime());
        assertEquals("bad run from", 10, task.getRunFrom());
        assertEquals("bad stop after", 11, task.getStopAfter());
        assertEquals("bad weight", 12, task.getWeight());

        List<Phase> phases = Arrays.asList(Phase.RUN, Phase.COOLDOWN, Phase.SETUP);
        assertTrue("bad phases",task.applicablePhases().containsAll(phases));


    }

    public void testSubClassFullyAnnotated()
    {
        final Task task = _taskDecoratorImpl.decorateInstance(new SubClassFullyAnnotatedClass());
        assertNotNull(task);
        assertEquals("bad name", "TestNameSubClass", task.getName());
        assertEquals("bad intertia", 1.3F, task.getInertia());
        assertEquals("bad max invocations", 200, task.getMaxInvocations());
        assertEquals("bad max time", 201, task.getMaxTime());
        assertEquals("bad run from", 10, task.getRunFrom());
        assertEquals("bad stop after", 11, task.getStopAfter());
        assertEquals("bad weight", 12, task.getWeight());

        List<Phase> phases = Arrays.asList(Phase.RUN, Phase.COOLDOWN, Phase.SETUP);
        assertTrue("bad phases", task.applicablePhases().containsAll(phases));
    }

    public void testSubSubClassFullyAnnotatedNotPhaseTest()
    {
        final Task task = _taskDecoratorImpl.decorateInstance(new SubSubClassFullyAnnotatedClassNotPhaseTest());
        assertNotNull(task);
        assertEquals("bad name", "TestNameSubClass", task.getName());
        assertEquals("bad intertia", 1.3F, task.getInertia());
        assertEquals("bad max invocations", 200, task.getMaxInvocations());
        assertEquals("bad max time", 201, task.getMaxTime());
        assertEquals("bad run from", 10, task.getRunFrom());
        assertEquals("bad stop after", 11, task.getStopAfter());
        assertEquals("bad weight", 12, task.getWeight());

        List<Phase> phases = Arrays.asList(Phase.COOLDOWN, Phase.SETUP);
        assertTrue("bad phases", task.applicablePhases().containsAll(phases));
        assertFalse("applicable phases contains unexpected run phase", task.applicablePhases().contains(Phase.RUN));
    }

    public void testDetermineExecuteMethodMoreThanOneAnnotation()
    {
        try
        {
            _taskDecoratorImpl.decorateInstance(new MoreThanOneExecutionMethodAnnotated());
            fail("unreachable");
        }
        catch (Exception e)
        {
            // Should happen
            assertEquals("bad message","Found more than 1 execute method",e.getMessage());
        }

    }

    public void testDetermineExecuteMethodAnnotatedMethodNotEmptyParams()
    {
        try
        {
            _taskDecoratorImpl.decorateInstance(new ExecutionMethodPresentNotEmptyParamsAnnotated());
            fail("unreachable");
        }
        catch (Exception e)
        {
            // Should happen
            assertEquals("bad message", "Execution method 'doit' requires parameters", e.getMessage());
        }
    }

    public void testDetermineExecuteMethodNoAnnotationDefaultMethodPresent()
    {
        final Task task = _taskDecoratorImpl.decorateInstance(new ExecutionMethodPresent());
        assertNotNull(task);
    }

    public void testDetermineExecuteMethodNoAnnotationDefaultMethodNotPresent()
    {
        try
        {
            _taskDecoratorImpl.decorateInstance(new NoExecutionMethodPresent());
            fail("unreachable");
        }
        catch (Exception e)
        {
            // Should happen
            assertEquals("bad message", "Could not find executeTask", e.getMessage());
        }
    }

    public void testDetermineExecuteMethodNoAnnotationDefaultMethodNotEmptyParams()
    {
        try
        {
            _taskDecoratorImpl.decorateInstance(new ExecutionMethodPresentNotEmptyParams());
            fail("unreachable");
        }
        catch (Exception e)
        {
            // Should happen
            assertEquals("bad message", "Could not find executeTask", e.getMessage());
        }
    }

    protected void setUp() throws Exception
    {
        super.setUp();
        _taskDecoratorImpl = new TaskDecoratorImpl();
        final ClassFactoryImpl classFactory = new ClassFactoryImpl();
        _taskDecoratorImpl.setClassFactory(classFactory);
        _taskDecoratorImpl.setLog(LogFactory.getLog(TaskDecoratorImpl.class));
    }
}
