/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.impl;

import junit.framework.TestCase;
import net.sourceforge.basher.internal.Randomizer;
import org.easymock.MockControl;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TestLimitedInMemoryEntityRegistry extends TestCase
{

    public void testLimit()
    {
        LimitedInMemoryEntityRegistry limitedInMemoryEntityRegistry = new LimitedInMemoryEntityRegistry();
        limitedInMemoryEntityRegistry.setLimit(3);

        MockControl randomizerControl = MockControl.createControl(Randomizer.class);
        Randomizer randomizer = (Randomizer) randomizerControl.getMock();
        limitedInMemoryEntityRegistry.setRandomizer(randomizer);

        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);
        randomizer.getRandomInt(3);
        randomizerControl.setReturnValue(0);

        randomizerControl.replay();


        final String entityIdentifier = "BOB";
        final String entityID1 = "FRED1";
        final String entityID2 = "FRED2";
        final String entityID3 = "FRED3";
        final String entityID4 = "FRED4";
        final String entityID5 = "FRED5";
        limitedInMemoryEntityRegistry.register(entityIdentifier, entityID1);
        limitedInMemoryEntityRegistry.register(entityIdentifier, entityID2);
        limitedInMemoryEntityRegistry.register(entityIdentifier, entityID3);

        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getNumRegistered(entityIdentifier));
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getAllRegistered(entityIdentifier).size());
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 10).size());
        assertEquals("Wrong number of entities returned", 2, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 2).size());


        limitedInMemoryEntityRegistry.register(entityIdentifier, entityID4);
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getNumRegistered(entityIdentifier));
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getAllRegistered(entityIdentifier).size());
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 10).size());
        assertEquals("Wrong number of entities returned", 2, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 2).size());

        limitedInMemoryEntityRegistry.register(entityIdentifier, entityID5);

        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getNumRegistered(entityIdentifier));
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getAllRegistered(entityIdentifier).size());
        assertEquals("Wrong number of entities registered", 3, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 10).size());
        assertEquals("Wrong number of entities returned", 2, limitedInMemoryEntityRegistry.getRandomSelection(entityIdentifier, 2).size());

        randomizerControl.verify();

    }

}
