package net.sourceforge.basher.events.impl;

import java.util.Queue;
import java.util.LinkedList;

import junit.framework.TestCase;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.TickEvent;
import org.easymock.EasyMock;
import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestSynchronousEventManager extends TestCase
{
    SynchronousEventManager _synchronousEventManager;
    public Queue _queue;
    public BasherEventListener _basherEventListener;
    public Log _log;
    public BasherEventListener _queueBasedBasherEventListener;

    public void testEmitEvent()
    {
        _log.isDebugEnabled();
        EasyMock.expectLastCall().andReturn(false).times(2);
        EasyMock.replay(_log);

        _synchronousEventManager.addBasherEventListener(_queueBasedBasherEventListener);
        final TickEvent tickEvent = new TickEvent(1);
        _synchronousEventManager.publish(tickEvent);
        final Object emittedEvent = _queue.poll();
        assertNotNull("no event", emittedEvent);
        assertEquals("bad event", tickEvent, emittedEvent);

        EasyMock.verify(_log);

    }

/*
    public void testAddBasherEventListener()
    {
        _log.isDebugEnabled();
        EasyMock.expectLastCall().andReturn(false);
        EasyMock.replay(_log);

        //assertTrue(_synchronousEventManager.addBasherEventListener(_basherEventListener));
        //assertFalse(_synchronousEventManager.addBasherEventListener(_basherEventListener));

        EasyMock.verify(_log);

    }

    public void testRemoveBasherEventListener()
    {
        _log.isDebugEnabled();
        EasyMock.expectLastCall().andReturn(false).times(2);
        EasyMock.replay(_log);

        _synchronousEventManager.addBasherEventListener(_basherEventListener);
        // assertTrue(_synchronousEventManager.removeBasherEventListener(_basherEventListener));
        // assertFalse(_synchronousEventManager.removeBasherEventListener(_basherEventListener));

        EasyMock.verify(_log);
    }

*/
    protected void setUp() throws Exception
    {
        super.setUp();
        _synchronousEventManager = new SynchronousEventManager();
        _queue = new LinkedList();

        _log = EasyMock.createMock(Log.class);

        _synchronousEventManager.setLog(_log);

        _queueBasedBasherEventListener = new BasherEventListener()
        {
            public void basherEvent(final BasherEvent basherEvent)
            {
                _queue.add(basherEvent);
            }
        };
        _basherEventListener = new BasherEventListener()
        {
            public void basherEvent(final BasherEvent basherEvent)
            {
            }
        };
    }
}
