package net.sourceforge.basher.events;

import junit.framework.TestCase;
import junitx.framework.Assert;
import junitx.framework.ObjectFactory;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Phase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestPhaseTransitionEvent extends TestCase
{

    public void testEqualsHashCode()
    {
        ObjectFactory objectFactory = new ObjectFactory()
        {

            final BasherContext context = new BasherContext();

            public Object createInstanceX()
            {
                return new PhaseTransitionEvent(context, Phase.SETUP, Phase.RUN);
            }


            public Object createInstanceY()
            {
                return new PhaseTransitionEvent(context, Phase.RUN, Phase.COOLDOWN);
            }
        };
        Assert.assertEqualsContract(objectFactory);
        Assert.assertHashCodeContract(objectFactory);

        objectFactory = new ObjectFactory()
        {

            final BasherContext context = new BasherContext();

            public Object createInstanceX()
            {
                return new PhaseTransitionEvent(context, Phase.SETUP, Phase.RUN);
            }


            public Object createInstanceY()
            {
                return new PhaseTransitionEvent(null, Phase.SETUP, Phase.RUN);
            }
        };
        Assert.assertEqualsContract(objectFactory);
        Assert.assertHashCodeContract(objectFactory);

        objectFactory = new ObjectFactory()
        {

            final BasherContext context = new BasherContext();

            public Object createInstanceX()
            {
                return new PhaseTransitionEvent(context, Phase.RUN, Phase.RUN);
            }


            public Object createInstanceY()
            {
                return new PhaseTransitionEvent(context, Phase.COOLDOWN, Phase.RUN);
            }
        };
        Assert.assertEqualsContract(objectFactory);
        Assert.assertHashCodeContract(objectFactory);

    }

    public void testValues()
    {
        final BasherContext context = new BasherContext();
        PhaseTransitionEvent phaseTransitionEvent = new PhaseTransitionEvent(context, Phase.SETUP,Phase.RUN);

        assertEquals("bad context", context, phaseTransitionEvent.getBasherContext());
        assertEquals("bad context", Phase.SETUP, phaseTransitionEvent.getOldPhase());
        assertEquals("bad context", Phase.RUN, phaseTransitionEvent.getNewPhase());

    }


}
