/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import org.easymock.MockControl;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class BasherTestCase extends TestCase
{
    private List<MockControl> _mockControls = new ArrayList<MockControl>();

    protected void sleep(final long period)
    {
        try
        {
            Thread.sleep(period);
        }
        catch (InterruptedException e)
        {
            fail(e.getMessage());
        }
    }

    public void addMockControl(final MockControl mockControl)
    {
        _mockControls.add(mockControl);
    }

    public void removeMockControl(final MockControl mockControl)
    {
        _mockControls.remove(mockControl);
    }

    public void clearMockControls()
    {
        _mockControls.clear();
    }

    public void verifyAllMockControls()
    {
        for (final MockControl mockControl : _mockControls)
        {
            mockControl.verify();
        }
    }

    public void replayAllMockControls()
    {
        for (final MockControl mockControl : _mockControls)
        {
            mockControl.replay();
        }
    }

    public void resetAllMockControls()
    {
        for (final MockControl mockControl : _mockControls)
        {
            mockControl.reset();
        }
    }
}
