/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.apache.commons.logging.Log;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.service.ObjectProvider;

/**
 * @author Johan Lindquist
 */
public class RegularExpressionObjectProvider implements ObjectProvider
{
    private Log _logger;

    public void setLog(final Log logger)
    {
        _logger = logger;
    }

    public Object provideObject(final Module module, final Class aClass, final String string, final Location location)
    {
        try
        {
            _logger.debug("Compiling pattern '" + string + "'");
            return Pattern.compile(string);
        }
        catch (PatternSyntaxException e)
        {
            throw new ApplicationRuntimeException("Invalid regular expression '" + string + "' specified", location, e);
        }
        catch (Exception e)
        {
            throw new ApplicationRuntimeException("Unknown error compiling regular expression", location, e);
        }
    }
}
