package net.sourceforge.basher.internal.impl;

import net.sourceforge.basher.Scheduler;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class BeanShellHelper
{
    private static Scheduler _scheduler;

    public static void setScheduler(final Scheduler scheduler)
    {
        _scheduler = scheduler;
    }

    public static void start(final String contextName)
    {
        _scheduler.start(contextName);
    }

    public static void start()
    {
        _scheduler.start();
    }

    public static void stop()
    {
        _scheduler.stop();
    }

    public static void addThread()
    {
        _scheduler.addThread();
    }

    public static void addThreads(final int numThreads)
    {
        _scheduler.addThreads(numThreads);
    }

    public static boolean isRunning()
    {
        return _scheduler.isRunning();
    }

    public static int getNumberOfActiveThreads()
    {
        return _scheduler.getNumberOfActiveThreads();
    }

    public static void removeThread()
    {
        _scheduler.removeThread();
    }

    public static void removeAllThreads()
    {
        _scheduler.removeAllThreads();
    }

}
