package net.sourceforge.basher.impl;

import java.util.TimerTask;

import net.sourceforge.basher.Phase;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.events.EventManager;
import net.sourceforge.basher.events.PhaseTransitionEvent;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class PhaseTransitionTimerTask extends TimerTask
{
    private final Phase _oldPhase;
    private final Phase _newPhase;
    private final EventManager _eventManager;
    private final BasherContext _basherContext;

    public PhaseTransitionTimerTask(final EventManager eventManager, final Phase oldPhase, final Phase newPhase, final BasherContext basherContext)
    {
        _oldPhase = oldPhase;
        _newPhase = newPhase;
        _eventManager = eventManager;
        _basherContext = basherContext;
    }

    public void run()
    {
        _eventManager.publish(new PhaseTransitionEvent(_basherContext, _oldPhase, _newPhase));
    }
}
