package net.sourceforge.basher.events;

import net.sourceforge.basher.BasherContext;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class ThreadAddedEvent extends BasherEvent
{
    private String _name;
    private final BasherContext _basherContext;

    public ThreadAddedEvent(final String name, final BasherContext basherContext)
    {
        _name = name;
        _basherContext = basherContext;
    }

    /** Returns the name of the thread to stop
     *
     * @return The name of the thread which should be stopped.
     */
    public String getName()
    {
        return _name;
    }

    public BasherContext getBasherContext()
    {
        return _basherContext;
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final ThreadAddedEvent event = (ThreadAddedEvent) o;

        if (_basherContext != null ? !_basherContext.equals(event._basherContext) : event._basherContext != null)
        {
            return false;
        }
        if (_name != null ? !_name.equals(event._name) : event._name != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (_name != null ? _name.hashCode() : 0);
        result = 31 * result + (_basherContext != null ? _basherContext.hashCode() : 0);
        return result;
    }


    public String toString()
    {
        return "ThreadAddedEvent{" +
                "_name='" + _name + '\'' +
                ", _basherContext=" + _basherContext +
                '}';
    }
}