/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

import java.util.List;

/** Class for managing contexts registered within the system.  A context is defined by the <code>BasherContext</code>
 * class and represents the runtime properties of a performance or testing run.
 *
 * @author Johan Lindquist
 * @version $Revision$
 */
public interface ContextManager
{
    public String DEFAULT_BASHER_CONTEXT_NAME = "default";

    /** Retrieves the currently active context.
     *
     * @return The active context
     */
    public BasherContext getActiveBasherContext();

    /** Sets the specified context to be the active, used context.
     *
     * @param basherContext The context to activate.
     */
    public void setActiveBasherContext(final BasherContext basherContext);

    /** Retrieves the by name specified context.
     *
     * @param contextName The name of the context to retrieve.
     * @return The specified context or null if not present.
     */
    public BasherContext getBasherContext(final String contextName);

    /** Retrieves the list of all registered contexts.
     *
     * @return The list of contexts available.
     */
    public List<BasherContext> getBasherContexts();

    /** Adds the specified context to the system.
     *
     * @param basherContext The context to add.
     */
    public void addBasherContext(final BasherContext basherContext);
}
