/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

/** Defines the context parameters for a performance or testing run.
 *
 * @author Johan Lindquist
 * @version $Revision$
 */
public class BasherContext
{
    private boolean awaitStartSignal = false;
    private long setupDuration = 0;
    private long runDuration = 0;
    private long cooldownDuration = 0;

    private long startCollectionFrom = 0;
    private long stopCollectionAfter = 0;

    private int initialNumberThreads = 10;
    private int maxNumberThreads = 0;
    private int threadIncrementCount = 0;
    private int threadIncrementInterval = 0;

    private int taskMinDelay;
    private int taskMaxDelay;

    private long markAverageInterval = 10;

    private String beanShellScriptDirectory = "src/test/basher-scripts";

    private String runIdentifier;

    private String reportDirectory;

    private ExecutionType executionType;

    private String name;

    // TODO: Add parameter which indicates which kind of management of the run(s) should be done
    // TODO: Automatic (simply just run it once), BeanShell controller (manual)

    public boolean isAwaitStartSignal()
    {
        return awaitStartSignal;
    }

    public void setAwaitStartSignal( final boolean awaitStartSignal )
    {
        this.awaitStartSignal = awaitStartSignal;
    }

    public String getBeanShellScriptDirectory()
    {
        return beanShellScriptDirectory;
    }

    public void setBeanShellScriptDirectory(final String beanShellScriptDirectory)
    {
        this.beanShellScriptDirectory = beanShellScriptDirectory;
    }

    public long getStartCollectionFrom()
    {
        return startCollectionFrom;
    }

    public void setStartCollectionFrom(final long startCollectionFrom)
    {
        this.startCollectionFrom = startCollectionFrom;
    }

    public long getStopCollectionAfter()
    {
        return stopCollectionAfter;
    }

    public void setStopCollectionAfter(final long stopCollectionAfter)
    {
        this.stopCollectionAfter = stopCollectionAfter;
    }

    public int getInitialNumberThreads()
    {
        return initialNumberThreads;
    }

    public void setInitialNumberThreads(final int initialNumberThreads)
    {
        this.initialNumberThreads = initialNumberThreads;
    }

    public int getMaxNumberThreads()
    {
        return maxNumberThreads;
    }

    public void setMaxNumberThreads(final int maxNumberThreads)
    {
        this.maxNumberThreads = maxNumberThreads;
    }

    public int getThreadIncrementCount()
    {
        return threadIncrementCount;
    }

    public void setThreadIncrementCount(final int threadIncrementCount)
    {
        this.threadIncrementCount = threadIncrementCount;
    }

    public int getThreadIncrementInterval()
    {
        return threadIncrementInterval;
    }

    public void setThreadIncrementInterval(final int threadIncrementInterval)
    {
        this.threadIncrementInterval = threadIncrementInterval;
    }

    public int getTaskMinDelay()
    {
        return taskMinDelay;
    }

    public void setTaskMinDelay(final int taskMinDelay)
    {
        this.taskMinDelay = taskMinDelay;
    }

    public int getTaskMaxDelay()
    {
        return taskMaxDelay;
    }

    public void setTaskMaxDelay(final int taskMaxDelay)
    {
        this.taskMaxDelay = taskMaxDelay;
    }

    public long getMarkAverageInterval()
    {
        return markAverageInterval;
    }

    public void setMarkAverageInterval(final long markAverageInterval)
    {
        this.markAverageInterval = markAverageInterval;
    }


    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public String getRunIdentifier()
    {
        return runIdentifier;
    }

    public void setRunIdentifier(final String runIdentifier)
    {
        this.runIdentifier = runIdentifier;
    }

    public String getReportDirectory()
    {
        return reportDirectory;
    }

    public void setReportDirectory(final String reportDirectory)
    {
        this.reportDirectory = reportDirectory;
    }

    public long getSetupDuration()
    {
        return setupDuration;
    }

    public void setSetupDuration(final long setupDuration)
    {
        this.setupDuration = setupDuration;
    }

    public long getRunDuration()
    {
        return runDuration;
    }

    public void setRunDuration(final long runDuration)
    {
        this.runDuration = runDuration;
    }

    public long getCooldownDuration()
    {
        return cooldownDuration;
    }

    public void setCooldownDuration(final long cooldownDuration)
    {
        this.cooldownDuration = cooldownDuration;
    }

    public ExecutionType getExecutionType()
    {
        return executionType;
    }

    public void setExecutionType(final ExecutionType executionType)
    {
        this.executionType = executionType;
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final BasherContext that = (BasherContext) o;

        if (cooldownDuration != that.cooldownDuration)
        {
            return false;
        }
        if (initialNumberThreads != that.initialNumberThreads)
        {
            return false;
        }
        if (markAverageInterval != that.markAverageInterval)
        {
            return false;
        }
        if (maxNumberThreads != that.maxNumberThreads)
        {
            return false;
        }
        if (runDuration != that.runDuration)
        {
            return false;
        }
        if (setupDuration != that.setupDuration)
        {
            return false;
        }
        if (startCollectionFrom != that.startCollectionFrom)
        {
            return false;
        }
        if (stopCollectionAfter != that.stopCollectionAfter)
        {
            return false;
        }
        if (taskMaxDelay != that.taskMaxDelay)
        {
            return false;
        }
        if (taskMinDelay != that.taskMinDelay)
        {
            return false;
        }
        if (threadIncrementCount != that.threadIncrementCount)
        {
            return false;
        }
        if (threadIncrementInterval != that.threadIncrementInterval)
        {
            return false;
        }
        if (beanShellScriptDirectory != null ? !beanShellScriptDirectory.equals(that.beanShellScriptDirectory) : that.beanShellScriptDirectory != null)
        {
            return false;
        }
        if (executionType != null ? !executionType.equals(that.executionType) : that.executionType != null)
        {
            return false;
        }
        if (name != null ? !name.equals(that.name) : that.name != null)
        {
            return false;
        }
        if (reportDirectory != null ? !reportDirectory.equals(that.reportDirectory) : that.reportDirectory != null)
        {
            return false;
        }
        if (runIdentifier != null ? !runIdentifier.equals(that.runIdentifier) : that.runIdentifier != null)
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = (int) (setupDuration ^ (setupDuration >>> 32));
        result = 31 * result + (int) (runDuration ^ (runDuration >>> 32));
        result = 31 * result + (int) (cooldownDuration ^ (cooldownDuration >>> 32));
        result = 31 * result + (int) (startCollectionFrom ^ (startCollectionFrom >>> 32));
        result = 31 * result + (int) (stopCollectionAfter ^ (stopCollectionAfter >>> 32));
        result = 31 * result + initialNumberThreads;
        result = 31 * result + maxNumberThreads;
        result = 31 * result + threadIncrementCount;
        result = 31 * result + threadIncrementInterval;
        result = 31 * result + taskMinDelay;
        result = 31 * result + taskMaxDelay;
        result = 31 * result + (int) (markAverageInterval ^ (markAverageInterval >>> 32));
        result = 31 * result + (beanShellScriptDirectory != null ? beanShellScriptDirectory.hashCode() : 0);
        result = 31 * result + (runIdentifier != null ? runIdentifier.hashCode() : 0);
        result = 31 * result + (reportDirectory != null ? reportDirectory.hashCode() : 0);
        result = 31 * result + (executionType != null ? executionType.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    @Override
    public String toString()
    {
        return "BasherContext{" +
                "setupDuration=" + setupDuration +
                ", runDuration=" + runDuration +
                ", cooldownDuration=" + cooldownDuration +
                ", startCollectionFrom=" + startCollectionFrom +
                ", stopCollectionAfter=" + stopCollectionAfter +
                ", initialNumberThreads=" + initialNumberThreads +
                ", maxNumberThreads=" + maxNumberThreads +
                ", threadIncrementCount=" + threadIncrementCount +
                ", threadIncrementInterval=" + threadIncrementInterval +
                ", taskMinDelay=" + taskMinDelay +
                ", taskMaxDelay=" + taskMaxDelay +
                ", markAverageInterval=" + markAverageInterval +
                ", beanShellScriptDirectory='" + beanShellScriptDirectory + '\'' +
                ", runIdentifier='" + runIdentifier + '\'' +
                ", reportDirectory='" + reportDirectory + '\'' +
                ", executionType=" + executionType +
                ", name='" + name + '\'' +
                '}';
    }
}