package net.sourceforge.basher.internal.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Timer;

import org.apache.commons.logging.Log;
import net.sourceforge.basher.internal.TimedTaskInvoker;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.PhaseTransitionEvent;
import net.sourceforge.basher.Phase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TimedTaskInvokerImpl implements TimedTaskInvoker, BasherEventListener
{
    private Log _logger;
    private List<TimedTaskInvokerInfo> _timedTaskInfos;
    private boolean _started = false;
    public Timer _timer;

    public void setLog(final Log logger)
    {
        _logger = logger;
    }

    public void setTimedTaskInfos(final List<TimedTaskInvokerInfo> timedTaskInfos)
    {
        _timedTaskInfos = timedTaskInfos;
    }

    public boolean isRunning()
    {
        return _started;
    }

    public void start()
    {
        if (_started)
        {
            throw new IllegalStateException("Already started");
        }

        if (_timedTaskInfos != null && !_timedTaskInfos.isEmpty())
        {
            // Setup the time
            _timer = new Timer(false);

            _logger.info("Timed Task Executor Starting");
            int count = 0;
            for (Iterator<TimedTaskInvokerInfo> iterator = _timedTaskInfos.iterator(); iterator.hasNext();)
            {
                final TimedTaskInvokerInfo timedExecutorInfo = iterator.next();

                // Is the execution interval less than 1 second?
                if (timedExecutorInfo.getInterval() * 1000 < 1000)
                {
                    _logger.warn("Timed task '" + timedExecutorInfo.getTimedTask().getName() + "' will not be run as interval is < 1 sec");
                    continue;
                }

                _logger.debug("Starting timed task '" + timedExecutorInfo.getTimedTask().getName() + "'");
                _timer.scheduleAtFixedRate(new SimpleTimerTask(timedExecutorInfo.getTimedTask(),_logger),timedExecutorInfo.getInterval()*1000,timedExecutorInfo.getInterval() * 1000);
                count++;
            }
            _logger.info("Timed Task Executors started.  " + count + " timed task(s) running");
        }
        else
        {
            _logger.info("No timed tasks to start");
        }
        _started = true;
    }

    public void stop()
    {
        if (!_started)
        {
            throw new IllegalStateException("Not started");
        }
        _logger.info("Stopping Timed Task Executor");
        // Cancel all times
        _timer.cancel();
        _timer.purge();
        _logger.info("Timed Task Executor Stopped");
        _started = false;
    }

    public void basherEvent(final BasherEvent basherEvent)
    {

        if (basherEvent instanceof PhaseTransitionEvent)
        {
            if (((PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.RUN)
            {
                start();
            }
            if (((PhaseTransitionEvent) basherEvent).getNewPhase() == Phase.COOLDOWN)
            {
                stop();
            }
        }

    }
}
