/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.util.TimerTask;

import net.sourceforge.basher.Task;
import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class SimpleTimerTask extends TimerTask
{
    private Task _task;
    private final Log _log;

    public SimpleTimerTask(final Task task, final Log log)
    {
        _task = task;
        _log = log;
    }

    public void run()
    {
        try
        {
            _task.executeTask();
        }
        catch (Throwable throwable)
        {
            _log.error(throwable.getMessage(),throwable);
        }
    }
}
